<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\OffersModule\Offer\Events\SendOffer;

class SendOfferMail
{

    private $templateRepository;
    private $logRepository;

    public function __construct(TemplateRepositoryInterface $templateRepository, LogRepositoryInterface $logRepository)
    {
        $this->templateRepository = $templateRepository;
        $this->logRepository = $logRepository;
    }

    public function handle(SendOffer $event)
    {
        $offer = $event->offer();
        $password = $event->password();

        $template = $this->templateRepository->findBySlug('send_offer');
        $template = $template->translateTemplate();
        $url = parse_url(url()->current());
        $url = $url['scheme'] . '://' . $url['host'];
        $template['message'] = str_replace('{emlak24_url}', $url, $template['message']);
        $template['message'] = str_replace('{offer_link}', route('message_details', [$offer->chat->id]), $template['message']);
        $template['message'] = str_replace('{name}', $offer->offered_to->name(), $template['message']);
        $template['message'] = str_replace('{email}', $offer->offered_to->email, $template['message']);
        $template['message'] = str_replace('{password}', $password, $template['message']);
        if (!is_null($template)) {
            $offer->offered_to->notify(new MailTemplate($template));
            $this->logRepository->createLog($offer->offered_to->email, $template['subject'], $template['message'], $template['greeting']);
        }
    }
}
