<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\DemandModule\Demand\Events\CreateDemand;
use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class CreateDemandMail
{

    private $templateRepository;
    private $logRepository;
    private $userRepository;

    public function __construct(
        TemplateRepositoryInterface $templateRepository,
        LogRepositoryInterface $logRepository,
        UserRepositoryInterface $userRepository
    )
    {
        $this->templateRepository = $templateRepository;
        $this->logRepository = $logRepository;
        $this->userRepository = $userRepository;
    }

    public function handle(CreateDemand $event)
    {
        $admin = $this->userRepository->find(1);
        $user = $event->user();
        $demandId = $event->demandId();

        $template = $this->templateRepository->findBySlug('create_demand');
        $template = $template->translateTemplate();
        $template['message'] = str_replace('{emlak24_url}', url('/'), $template['message']);
        $template['message'] = str_replace('{name}', $user->name(), $template['message']);
        $template['message'] = str_replace('{request_id}', $demandId, $template['message']);

        $user->notify(new MailTemplate($template));
        $admin->notify(new MailTemplate($template));

        $this->logRepository->createLog($user->email, $template['subject'], $template['message'], $template['greeting']);
        $this->logRepository->createLog($admin->email, $template['subject'], $template['message'], $template['greeting']);
    }
}
