<?php namespace Visiosoft\NotificationsModule\Notify\Listener;

use Visiosoft\NotificationsModule\Notify\Notification\UpdateAdAdminMail;
use Illuminate\Events\Dispatcher;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\Event\EditAd;
use Visiosoft\NotificationsModule\Notify\Notification\UpdateAdUserMail;
use Visiosoft\NotificationsModule\Notify\NotifyModel;
use Visiosoft\NotificationsModule\Smsnotify\Event\UpdateAdSms;

class UpdateAd
{
    public function __construct(Dispatcher $events)
    {
        $this->events = $events;
        $this->model = new NotifyModel();
    }

    public function handle(EditAd $event)
    {
        $ad_id = $event->request;
        $ad = $this->model->getAd($ad_id);
        $user = $this->model->getUser($ad->created_by_id);

        if ($event->settings->value('visiosoft.module.notifications::user_notifications') == true) {
            $user->notify(new UpdateAdUserMail($ad,$user,$event->settings));
        }
        if ($event->settings->value('visiosoft.module.notifications::admin_notifications') == true) {
            $user = Auth::user();
            $user->notify(new UpdateAdAdminMail($ad,$user,$event->settings));
        }
        if ($event->settings->value('visiosoft.module.notifications::update_ad_user_sms') == true) {
            $user = Auth::user();
            $msg = $event->settings->value('visiosoft.module.notifications::update_ad_user_sms_msg');
            $this->events->dispatch(new UpdateAdSms($user,$msg));
        }
    }
}


