<?php

namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\TicketsModule\Ticket\Event\TicketClosedEmailEvent;

class TicketAnsweredAdminEmailListener
{
    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    public function handle(TicketClosedEmailEvent $event)
    {
        $person = $event->getPerson();
        $ticket = $event->getTicket();
        $params = [
            'ticket_number' => '#' . $ticket->ticket_number,
        ];
        $template = $this->template->findBySlug('ticket_answered_admin');
        if ($template and $email = $person->email) {
            $person->notify(new MailTemplate($template->getTemplateForArray($params), $email));
        }
    }
}