<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Str;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SiteModule\Site\Event\FailedSiteSSL;

class FailedSiteSSLMail
{
    private $template;
    private $user;
    private $roleRepository;

    public function __construct(
        RoleRepositoryInterface $roleRepository,
        UserRepositoryInterface $user,
        TemplateRepositoryInterface $template
    )
    {
        $this->roleRepository = $roleRepository;
        $this->template = $template;
        $this->user = $user;
    }

    public function handle(FailedSiteSSL $event)
    {
        //Set Admins
        $adminRole = $this->roleRepository->findBySlug('admin');
        $admins = $adminRole->getUsers();

        $html = "<table>";

        foreach ($event->getSites() as $site) {
            $html .= "<tr><td><a href='$site'>$site</a></td></tr>";
        }

        $html .= "</table>";

        $mail_params = [
            'html' => $html
        ];

        //Send Admins
        foreach ($admins as $admin) {
            if ($template = $this->template->findBySlug(Str::slug('Failed Site SSL', '_'))) {
                $admin->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
            }
        }
    }
}
