<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SiteModule\Site\Event\subscriptions\ErrorSuspendSiteForSubscription;

class ErrorSuspendSiteForSubscriptionByAdminMail
{

    private $template;
    private $roleRepository;

    public function __construct(
        RoleRepositoryInterface $roleRepository,
        TemplateRepositoryInterface $template
    )
    {
        $this->roleRepository = $roleRepository;
        $this->template = $template;
    }

    public function handle(ErrorSuspendSiteForSubscription $event)
    {
        //Set Admins
        $adminRole = $this->roleRepository->findBySlug('admin');
        $admins = $adminRole->getUsers();

        $site = $event->getSite();
        $template = $this->template->findBySlug(str_slug('Error Suspend Site For Subscription By Admin', '_'));

        if ($user = $site->assign and $template) {

            $mail_params = [
                'display_name' => $user->display_name,
                'url' => $site->subdomain_name . "." . $site->type,
            ];

            //Send Admins
            foreach ($admins as $admin) {
                $admin->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
            }
        }

    }
}
