<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Str;
use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\CouponModule\Coupon\Event\Coupon;
class CouponMail
{
    private $template;
    private $userRepository;
    private $codeRepository;
    public function __construct(
        TemplateRepositoryInterface $template,
        UserRepositoryInterface $userRepository,
        CodeRepositoryInterface $codeRepository
    )
    {
        $this->template = $template;
        $this->userRepository = $userRepository;
        $this->codeRepository = $codeRepository;
    }

    public function handle(Coupon $event)
    {
        foreach ($event->getCouponTypeEntry() as $key=>$couponType) {
            $coupon = $this->codeRepository->newQuery()->where('coupon_id',$event->getEntry()->id)->get()->$key;

            $mail_params = [
                'discount_value' => $event->getEntry()->discount_value,
                'coupon_code' => $coupon->code,
                'discount_symbol' => '',
                'html' => ""
            ];

            if ($event->getEntry()->discount_type != 'fixed_amount'){
                $mail_params['discount_symbol'] = '%';
            }

            if (isset($event->getEntry()->coupon_expiry_at)){
                $mail_params['html'] = "<table><tr><td><div >". trans('visiosoft.module.notifications::field.expiry_time') .": ".$event->getEntry()->coupon_expiry_at."</div></td></tr></table>";
            }

            if ($template = $this->template->findBySlug(Str::slug('coupon'))) {
                $this->userRepository->newQuery()->find($couponType)->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
            }
        }
    }
}
