<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class RegisteredUser
{
    private $template;
    private $user;

    public function __construct(
        UserRepositoryInterface $user,
        TemplateRepositoryInterface $template)
    {
        $this->template = $template;
        $this->user = $user;
    }

    public function handle(UserHasRegistered $event)
    {
        $user = $event->getUser();
        $template = $this->template->findBySlug('registered_user');
        if (!is_null($template)) {
            $user->notify(new MailTemplate($template->getTemplateForArray($user->toArray())));
        }
    }
}
