<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SiteModule\Site\Event\CreateSiteForUser;

class CreateSiteForUserMail
{

    private $template;
    private $log;

    public function __construct(TemplateRepositoryInterface $templateRepository, LogRepositoryInterface $logRepository)
    {
        $this->template = $templateRepository;
        $this->log = $logRepository;
    }

    public function handle(CreateSiteForUser $event)
    {
        $site = $event->getSite();
        $user = $event->getUser();

        $template = $this->template->findBySlug('openclassify_user_created');

        $mail_params = [
            'display_name' => $user->display_name,
            'email' => $user->email,
            'password' => $site->password,
            'login_url' => url('login')
        ];

        if (!is_null($template)) {
            $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
            $this->log->createLog($user->email, $template['subject'], $template['message'], $template['greeting'], $site);
        }
    }
}
