<?php namespace Visiosoft\NotificationsModule\Template;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Str;
use Visiosoft\NotificationsModule\Template\Command\CreateTemplate;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class TemplateSeeder extends Seeder
{
    use DispatchesJobs;
    /**
     * Run the seeder.
     */
    public function run()
    {

        $templates = [
            [
                'en' => [
                    'message' => '<tr>
                                    <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                        <table width="100%" cellspacing="0" cellpadding="0">
                                            <tbody>
                                            <tr>
                                                <td class="esd-container-frame" width="560" valign="top" align="center">
                                                    <table width="100%" cellspacing="0" cellpadding="0">
                                                        <tbody>
                                                        <tr>
                                                            <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                <h2><strong>About Covid-19</strong></h2>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="esd-block-text es-p20t" align="left">
                                                                <p style="color: #707070;">Hi user,</p>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="esd-block-text es-p15t" align="left">
                                                                <p style="color: #707070;">Sağlığınızı önemsiyoruz!<br>Hassas günlerden geçtiğimiz bu dönemde, kendinin ve çevrendekilerin sağlığını düşünüyoruz. Bu dönemde bizlerden almış olduğunuz hizmette bir aksama veya gecikme yaşanmayacağını belirtir, hassas bir şekilde çalışmalarımızın devam ettiğini bilmenizi isteriz.</p>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="esd-block-text es-p15t" align="left">
                                                                <p style="color: #707070;">Koronavirüs (COVID-19) salgınının yayılmasını engellemek için sosyal izolasyonun önemini hatırlatarak sağlıklı günler dileriz.</p>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="esd-block-text es-p20t" align="left">
                                                                <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                    <tbody>
                                                                    <tr>
                                                                        <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>',
                    'name' => 'General Layout',
                    'subject' => 'General Layout | Openclassify.com'
                ],
                'slug' => Str::slug('General Layout', '_')
            ],
            [
                'en' => [
                    'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p40b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2 style="font-size: 26px;"><strong>10% Discount on All Modules</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">The module you need is waiting for you with its discounted price.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="194" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="174" class="es-m-p0r es-m-p20b esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/87661596546265384.png" alt style="display: block;" width="174"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                                 <td class="es-hidden" width="20"></td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="173" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="173" class="es-m-p20b esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/90601596546277490.png" alt style="display: block;" width="173"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="173" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="173" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/57131596546288213.png" alt style="display: block;" width="173"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p10t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="194" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="174" class="es-m-p0r es-m-p20b esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/41001596546304817.png" alt style="display: block;" width="174"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                                 <td class="es-hidden" width="20"></td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="173" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="173" class="es-m-p20b esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/55601596546312625.png" alt style="display: block;" width="173"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="173" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="173" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/36601596546319934.png" alt style="display: block;" width="173"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p35t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-button es-p10"><span class="es-button-border" style="background: #ffb600; border-radius: 4px; border-bottom-width: 0px;"><a href class="es-button" target="_blank" style="background: #ffb600; border-color: #ffb600; border-radius: 4px; font-size: 16px; border-width: 10px 35px;">SHOP NOW</a></span></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="60"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                    'name' => 'Discount',
                    'subject' => 'Discount | Openclassify.com'
                ],
                'slug' => Str::slug('Discount', '_')
            ],
            [
                'en' => [
                    'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Openclassify Has Published 2 New Modules!</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Yayınlanan yeni modüller ile hemen tanışın.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="22"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p40t es-p20r es-p20l" align="left" bgcolor="#ffb600" style="background-color: #ffb600; border-radius: 70px 70px 0 0; border-collapse: separate;">
                                         <!--[if mso]><table  width="560" cellpadding="0" cellspacing="0"><tr><td width="107" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="107" class="es-m-p0r esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-image es-m-p0 es-m-txt-c" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_12a6c1bb31cfa2b1280c9c688e9e4290/images/42701596533172501.png" alt style="display: block;" width="90"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="15"></td><td width="438" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="438" class="esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr class="es-mobile-hidden">
                                                             <td align="center" class="esd-block-spacer" height="25"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text">
                                                                 <p style="line-height: 150%;"><span style="color: #ffffff;"><strong><span style="font-size: 23px; line-height: 150%;">Algoia Search Integration</span></strong></span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p25t es-p40r es-p40l" align="left" bgcolor="#ffb600" style="background-color: #ffb600;">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="520" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-l">
                                                                 <h2>Algoia Search Integration<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-p15t">
                                                                 <p>Where been&nbsp;are the industry\'s standard. Lorem Ipsum is simply dummy text of the&nbsp;been worked the industry printing and industry. Has been worked the industry\'s standard dummy text ever as Ipsum&nbsp;<br>since the 1500s when.&nbsp;<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-p10t">
                                                                 <p style="font-size: 20px;"><strong>$590</strong></p>
                                                                 <p style="display: none;"><br></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20r es-p20l" align="left" bgcolor="#ffb600" style="background-color: #ffb600;">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 1px solid #e5a300; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p15t es-p20r es-p20l" align="left" bgcolor="#ffb600" style="background-color: #ffb600;">
                                         <!--[if mso]><table  width="560" cellpadding="0" cellspacing="0"><tr><td width="107" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="107" class="es-m-p0r esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-image es-m-p0 es-m-txt-c" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_12a6c1bb31cfa2b1280c9c688e9e4290/images/30511596540466287.png" alt style="display: block;" width="90"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="15"></td><td width="438" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="438" class="esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr class="es-mobile-hidden">
                                                             <td align="center" class="esd-block-spacer" height="31"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text">
                                                                 <p style="line-height: 150%;"><span style="color: #ffffff;"><strong><span style="font-size: 23px; line-height: 150%;">Algoia Search Integration</span></strong></span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p25t es-p40b es-p40r es-p40l" align="left" bgcolor="#ffb600" style="background-color: #ffb600; border-radius: 0 0 70px 70px; border-collapse: separate;">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="520" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-l">
                                                                 <h2>Algoia Search Integration<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-p15t">
                                                                 <p>Where been&nbsp;are the industry\'s standard. Lorem Ipsum is simply dummy text of the&nbsp;been worked the industry printing and industry. Has been worked the industry\'s standard dummy text ever as Ipsum&nbsp;<br>since the 1500s when.&nbsp;<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-p10t">
                                                                 <p style="font-size: 20px;"><strong>$590</strong></p>
                                                                 <p style="display: none;"><br></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-button es-p20t es-p25b es-p10r es-p10l"><span class="es-button-border" style="border-color: #2cb543; background: #ffffff; border-radius: 4px; border-width: 0px;"><a href class="es-button" target="_blank" style="background: #ffffff; border-color: #ffffff; color: #ffcc33; border-radius: 4px; font-size: 16px; border-width: 10px 20px; font-weight: normal;">SHOP NOW</a></span></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="19"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                    'name' => 'Newsletter',
                    'subject' => 'Newsletter | Openclassify.com'
                ],
                'slug' => Str::slug('Newsletter', '_')
            ],
            [
                'en' => [
                    'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Fiyat Teklifi</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Talebinize istinaden proje fiyat teklifimiz ekteki dosyadadır. Hazırlanacak olan web siteniz mobil uyumlu/ seo uyumlu/ bulut sunucu teknolojisine entegre/ konforlu bir yönetim paneline ve merkezi sistemde çalışan bir yazılım altyapısındadır.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                    'name' => 'Offer',
                    'subject' => 'Offer | Openclassify.com'
                ],
                'slug' => Str::slug('Offer', '_')
            ],
            [
                'en' => [
                    'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Free Usage For 3 Months</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Openclassify ı 3 ay ücretsiz kullanmak için bizi referans olarak göstermen yeterli olacaktır. Referansın ile gelen kullanıcılar için ayrıca openclassify modüllerinde indirim fırsatından da yararlanabilirsin.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="40"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_0eec0198a32138f799a69ff00115f284/images/38801596545998067.png" alt style="display: block;" width="560"></a></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="51"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                    'name' => 'Referral',
                    'subject' => 'Referral | Openclassify.com'
                ],
                'slug' => Str::slug('Referral', '_')
            ],
            [
                'en' => [
                    'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Renewal Reminder</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t es-p15b" align="left">
                                                                 <p style="color: #707070;">Thank you for choosing Openclassify for your website&nbsp;<a href="https://my.stripo.email/cabinet/#">https://demo.openclassify.com</a></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t es-p15b" align="left">
                                                                 <p style="color: #000000;">As a friendly reminder, your account will . renewed for $96.00 on January 22, 2015. If you wish to keep your account with us, no action is required.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                    'name' => 'Renewal Reminder',
                    'subject' => 'Renewal Reminder | Openclassify.com'
                ],
                'slug' => Str::slug('Renewal Reminder', '_')
            ],
            [
                'en' => [
                    'message' => '<p><strong>A New Find House Application Was Created By {name}</strong></p><p>Cell Phone: {cell_phone}</p><p>E-Mail Address: {email}</p>',
                    'name' => 'Find House',
                    'greeting' => 'Hello',
                    'subject' => 'Find House'
                ],
                'slug' => 'find_house'
            ]
        ];

        foreach ($templates as $template) {
            $this->dispatchNow(new CreateTemplate($template));
        }
    }
}
