<?php namespace Visiosoft\NotificationsModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Console\Command;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class NotificationsModuleSeeder extends Seeder
{
    public $templateRepository;

    public function __construct(TemplateRepositoryInterface $templateRepository)
    {
        $this->templateRepository = $templateRepository;
    }


    public $templates = [
        'created_ad' => [
            'slug' => 'created_ad',
            'en' => [
                'name' => 'Your uploaded ad has been created',
                'subject' => 'Your uploaded ad has been created',
                'greeting' => 'Hello',
                'message' => '<p><strong>&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;your post has been successfully created.&nbsp;</strong></p>'
            ],
            'de' => [
                'name' => 'Ihre hochgeladene Anzeige wurde erstellt',
                'subject' => 'Ihre hochgeladene Anzeige wurde erstellt',
                'greeting' => 'Hallo',
                'message' => '<p><strong>&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;Ihr Beitrag wurde erfolgreich erstellt.&nbsp;</strong></p>'
            ],
            'tr' => [
                'name' => 'Yüklediğiniz ilanınız oluşturuldu',
                'subject' => 'Yüklediğiniz ilanınız oluşturuldu',
                'greeting' => 'Merhaba',
                'message' => '<p><strong>&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;gönderiniz başarıyla oluşturuldu.&nbsp;</strong></p>'
            ],
        ],
        'approved_ad' => [
            'slug' => 'approved_ad',
            'en' => [
                'name' => 'Your uploaded ad has been approved.',
                'subject' => 'Your uploaded ad has been approved.',
                'greeting' => 'Hello',
                'message' => '<p><strong>Your ad has been approved for :name.&nbsp;<a href="{url}" target="_blank">{name}</a></strong></p>'
            ],
            'de' => [
                'name' => 'Ihre hochgeladene Anzeige wurde genehmigt.',
                'subject' => 'Ihre hochgeladene Anzeige wurde genehmigt.',
                'greeting' => 'Hallo',
                'message' => '<p><strong>Ihre Anzeige wurde genehmigt :name.&nbsp;<a href="{url}" target="_blank">{name}</a></strong></p>'
            ],
            'tr' => [
                'name' => 'Yüklediğiniz ilanınız onaylandı',
                'subject' => 'Yüklediğiniz ilanınız onaylandı',
                'greeting' => 'Merhaba',
                'message' => '<p><strong>:name için ilanınız onaylandı.&nbsp;<a href="{url}" target="_blank">{name}</a></strong></p>'
            ],
        ],
        'ad_extend_reminder' => [
            'slug' => 'ad_extend_reminder',
            'en' => [
                'name' => 'Ad Extend Reminder !',
                'subject' => 'Reminder For Your Ads.',
                'greeting' => 'Hello',
                'message' => '<p><strong>Your ad(s) will not be displayed after {day} days.&nbsp;<a href="{url}" target="_blank">Login and check now.</a></strong></p>'
            ],
            'de' => [
                'name' => 'Erinnerung zur Anzeigenerneuerung !',
                'subject' => 'Erinnerung für Ihre Anzeigen.',
                'greeting' => 'Hallo',
                'message' => '<p><strong>Ihre Anzeige wird nach {day} Tagen nicht angezeigt.&nbsp;<a href="{url}" target="_blank">Anmelden und prüfen.</a></strong></p>'
            ],
            'tr' => [
                'name' => 'İlan Yayından Kaldırılma Uyarısı !',
                'subject' => 'İlanlarınız İçin Uyarı.',
                'greeting' => 'Merhaba',
                'message' => '<p><strong>{day} gün sonra ilanlarınızdan bazıları yayından kaldırılacaktır.&nbsp;<a href="{url}" target="_blank">Giriş yap ve kontrol et.</a></strong></p>'
            ],
        ],
        'declined_ad' => [
            'slug' => 'declined_ad',
            'en' => [
                'name' => 'Your uploaded ad has been rejected.',
                'subject' => 'Your uploaded ad has been rejected.',
                'greeting' => 'Hello',
                'message' => '<p><strong>Because your ad does not comply with the posting rules&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;rejected.</strong></p>'
            ],
            'de' => [
                'name' => 'Ihre hochgeladene Anzeige wurde abgelehnt.',
                'subject' => 'Ihre hochgeladene Anzeige wurde abgelehnt.',
                'greeting' => 'Hallo',
                'message' => '<p><strong>Weil Ihre Anzeige nicht den Veröffentlichungsregeln entspricht&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;rejected.</strong></p>'
            ],
            'tr' => [
                'name' => 'Yüklediğiniz ilanınız reddedildi',
                'subject' => 'Yüklediğiniz ilanınız reddedildi',
                'greeting' => 'Merhaba',
                'message' => '<p><strong>İlanınız gönderim kurallarına uymadığı için&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;reddedildi.</strong></p>'
            ],
        ],
        'pending_user_ad' => [
            'slug' => 'pending_user_ad',
            'en' => [
                'name' => 'Your Pending User post has been created',
                'subject' => 'Your Pending User post has been created',
                'greeting' => 'Hello',
                'message' => '<p><strong>Confirm your post to appear.&nbsp;<a href="{url}" target="_blank">{name}</a></strong></p>'
            ],
            'de' => [
                'name' => 'Ihr ausstehender Benutzerbeitrag wurde erstellt',
                'subject' => 'Ihr ausstehender Benutzerbeitrag wurde erstellt',
                'greeting' => 'Hallo',
                'message' => '<p><strong>Bestätigen Sie, dass Ihr Beitrag angezeigt wird.&nbsp;<a href="{url}" target="_blank">{name}</a></strong></p>'
            ],
            'tr' => [
                'name' => 'Bekleyen Kullanıcı ilanınız oluşturuldu',
                'subject' => 'Bekleyen Kullanıcı ilanınız oluşturuldu',
                'greeting' => 'Merhaba',
                'message' => '<p><strong>Yayınınızın ortaya çıkması için onaylayınız.&nbsp;<a href="{url}" target="_blank">{name}</a></strong></p>'
            ],
        ],
        'pending_ad' => [
            'slug' => 'pending_ad',
            'en' => [
                'name' => 'Your Ad Pending Approval has been created',
                'subject' => 'Your Ad Pending Approval has been created',
                'greeting' => 'Hello',
                'message' => '<p><strong>Your post&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;controlled by our editors.&nbsp;</strong></p>'
            ],
            'de' => [
                'name' => 'Ihre Anzeige mit ausstehender Genehmigung wurde erstellt',
                'subject' => 'Ihre Anzeige mit ausstehender Genehmigung wurde erstellt',
                'greeting' => 'Hallo',
                'message' => '<p><strong>Ihr Beitrag&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;wird von unseren Redakteuren kontrolliert.&nbsp;</strong></p>'
            ],
            'tr' => [
                'name' => 'Onay Bekleyen ilanınız oluşturuldu',
                'subject' => 'Onay Bekleyen ilanınız oluşturuldu',
                'greeting' => 'Merhaba',
                'message' => '<p><strong>Gönderiniz&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;editörlerimiz tarafından kontrol edilmektedir.&nbsp;</strong></p>'
            ],
        ],
        'registered_user' => [
            'slug' => 'registered_user',
            'en' => [
                'name' => 'Registered User',
                'subject' => 'Your Membership Has Been Successfully Created',
                'greeting' => 'Hello {first_name}',
                'message' => '<p><strong>Your subscription has been activated.<br>Email:{email}</strong></p>'
            ],
            'de' => [
                'name' => 'registrierter Nutzer',
                'subject' => 'Ihre Mitgliedschaft wurde erfolgreich erstellt',
                'greeting' => 'Hallo {first_name}',
                'message' => '<p><strong>Ihr Abonnement wurde aktiviert.<br>Email:{email}</strong></p>'
            ],
            'tr' => [
                'name' => 'Kayıtlı Kullanıcı',
                'subject' => 'Üyeliğiniz Başarıyla Oluşturuldu',
                'greeting' => 'Merhaba Sayın {first_name}',
                'message' => '<p><strong>Üyeliğiniz aktive edildi.<br>E posta:{email}</strong></p>'
            ],
        ],
        'order_created' => [
            'slug' => 'order_created',
            'en' => [
                'name' => 'Order Created!',
                'subject' => 'Order Created!',
                'greeting' => 'Hello {display_name}',
                'message' => '<p class="text-center">Order Created!</p><p><br></p><p class="text-center">{items}</p><p><br></p><p class="text-center"><a href="{url}">Show </a>Order Detail</p><p><br></p>'
            ],
            'de' => [
                'name' => 'Bestellung erstellt!',
                'subject' => 'Bestellung erstellt!',
                'greeting' => 'Hallo {display_name}',
                'message' => '<p class="text-center">Bestellung erstellt!</p><p><br></p><p class="text-center">{items}</p><p><br></p><p class="text-center"><a href="{url}">Bestelldetail </a>anzeigen</p><p><br></p>'
            ],
            'tr' => [
                'name' => 'Sipariş Oluşturuldu!',
                'subject' => 'Sipariş Oluşturuldu!',
                'greeting' => 'Merhaba {display_name}',
                'message' => '<p class="text-center">Sipariş Oluşturuldu!</p><p><br></p><p class="text-center">{items}</p><p><br></p><p class="text-center">Sipariş Detayını <a href="{url}"> Göster</a></p><p><br></p>'
            ],
        ],
        'message_notification' => [
            'slug' => 'message_notification',
            'en' => [
                'name' => 'Message Notification',
                'subject' => 'You have a new message',
                'greeting' => 'Hello',
                'message' => '<p><strong>You\'ve got a message {name}</strong></p><p>Message: {message}</p>'
            ],
            'de' => [
                'name' => 'Benachrichtigung',
                'subject' => 'Du hast eine neue Nachricht',
                'greeting' => 'Hallo',
                'message' => '<p><strong>Sie haben eine Nachricht bekommen {name}</strong></p><p>Nachricht: {message}</p>'
            ],
            'tr' => [
                'name' => 'Mesaj Bildirimi',
                'subject' => 'Yeni mesajınız var',
                'greeting' => 'Merhaba',
                'message' => '<p><strong>Mesajınız var {name}</strong></p><p>Mesaj: {message}</p>'
            ],
        ],
        'created_refund_notification_for_user' => [
            'slug' => 'created_refund_notification_for_user',
            'en' => [
                'name' => 'Refund Notification Created for User',
                'subject' => 'Your Product Return Request Has Been Received',
                'greeting' => 'Hello',
                'message' => '<h1>Your Product Return Request Has Been Received!</h1><p>Your Product Return Request Has Been Received.&nbsp;<a href="{ad_url}">{ad_name}</a></p><p>Show Queue</p>'
            ],
            'de' => [
                'name' => 'Rückerstattungsbenachrichtigung für Benutzer erstellt',
                'subject' => 'Ihre Produktrückgabeanforderung wurde erhalten',
                'greeting' => 'Hallo',
                'message' => '<h1>Ihre Produktrückgabeanforderung wurde erhalten!</h1><p>Ihre Produktrückgabeanforderung wurde erhalten.&nbsp;<a href="{ad_url}">{ad_name}</a></p><p>Warteschlange anzeigen</p>'
            ],
            'tr' => [
                'name' => 'Kullanıcı İçin Geri Ödeme Bildirimi Oluşturuldu',
                'subject' => 'Ürün İade Talebiniz Alındı',
                'greeting' => 'Merhaba',
                'message' => '<h1>Ürün İade Talebiniz Alındı!</h1><p>Ürün iade talebiniz alındı.&nbsp;<a href="{ad_url}">{ad_name}</a></p><p>Sırayı Gösterin</p>'
            ],
        ],
        'created_refund_notification_for_seller' => [
            'slug' => 'created_refund_notification_for_seller',
            'en' => [
                'name' => 'Refund Notice Created for Seller',
                'subject' => 'Your product return request has been received!',
                'greeting' => 'Hello',
                'message' => '<h1>Your Product Return Request Has Been Received</h1><p>Your product return request has been received.&nbsp;<a href="{ad_url}">{ad_name}</a></p><p>Show Queue</p>'
            ],
            'de' => [
                'name' => 'Rückerstattungsbenachrichtigung für den Verkäufer erstellt',
                'subject' => 'Ihre Anfrage zur Produktrückgabe ist eingegangen!',
                'greeting' => 'Hallo',
                'message' => '<h1>Ihre Produktrückgabeanforderung wurde erhalten</h1><p>Ihre Anfrage zur Produktrückgabe ist eingegangen.&nbsp;<a href="{ad_url}">{ad_name}</a></p><p>Warteschlange anzeigen</p>'
            ],
            'tr' => [
                'name' => 'Satıcı İçin Geri Ödeme Bildirimi Oluşturuldu',
                'subject' => 'Ürün iade talebiniz alındı!',
                'greeting' => 'Merhaba',
                'message' => '<h1>Ürün İade Talebiniz Alındı</h1><p>Ürün iade talebiniz alındı.&nbsp;<a href="{ad_url}">{ad_name}</a></p><p>Sırayı Gösterin</p>'
            ],
        ],
        'created_refund_notification_for_admin' => [
            'slug' => 'created_refund_notification_for_admin',
            'en' => [
                'name' => 'Refund Notification Created for Manager.',
                'subject' => 'Return Request {ad_name}',
                'greeting' => 'Hello',
                'message' => '<h1>Return Request&nbsp;{ad_name}</h1><p>A return request has been created.&nbsp;<a href="{ad_url}">{ad_name}</a>.</p><p>Show Refund Request</p>'
            ],
            'de' => [
                'name' => 'Rückerstattungsbenachrichtigung für Manager erstellt.',
                'subject' => 'Rückgabeanfrage {ad_name}',
                'greeting' => 'Hallo',
                'message' => '<h1>Rückgabeanfrage&nbsp;{ad_name}</h1><p>Eine Rücksendeanforderung wurde erstellt.&nbsp;<a href="{ad_url}">{ad_name}</a>.</p><p>Rückerstattungsanforderung anzeigen</p>'
            ],
            'tr' => [
                'name' => 'Yönetici İçin Geri Ödeme Bildirimi Oluşturuldu.',
                'subject' => 'İade Talebi {ad_name}',
                'greeting' => 'Merhaba',
                'message' => '<h1>İade Talebi&nbsp;{ad_name}</h1><p>Bir iade talebi oluşturuldu.&nbsp;<a href="{ad_url}">{ad_name}</a>.</p><p>Geri Ödeme İsteğini Gösterin</p>'
            ],
        ],
        'refund_status_changed_for_user' => [
            'slug' => 'refund_status_changed_for_user',
            'en' => [
                'name' => 'Refund Status Changed Notification for User',
                'subject' => 'Your Product Return Status Has Been Concluded.',
                'greeting' => 'Hello',
                'message' => '<h1>Your product return status has been concluded!</h1><p>Your product return status&nbsp;<a href="{ad_url}">{ad_name}</a>&nbsp;concluded.</p><p>{refund_message}</p><p>Show Queue</p>'
            ],
            'de' => [
                'name' => 'Benachrichtigung über geänderten Rückerstattungsstatus für den Benutzer',
                'subject' => 'Ihr Produktrückgabestatus wurde abgeschlossen.',
                'greeting' => 'Hallo',
                'message' => '<h1>Ihr Produktrückgabestatus wurde abgeschlossen!</h1><p>Ihr Produktrückgabestatus&nbsp;<a href="{ad_url}">{ad_name}</a>&nbsp;abgeschlossen.</p><p>{refund_message}</p><p>Warteschlange anzeigen</p>'
            ],
            'tr' => [
                'name' => 'Kullanıcı İçin Geri Ödeme Durumu Değişti Bildirimi',
                'subject' => 'Ürün İade Durumunuz Sonuçlandı.',
                'greeting' => 'Merhaba',
                'message' => '<h1>Ürün iade durumunuz sonuçlandı!</h1><p>Ürün iade durumunuz&nbsp;<a href="{ad_url}">{ad_name}</a>&nbsp;sonuçlandı.</p><p>{refund_message}</p><p>Sırayı Gösteriniz</p>'
            ],
        ],
        'refund_status_changed_for_seller' => [
            'slug' => 'refund_status_changed_for_seller',
            'en' => [
                'name' => 'Refund Status Changed Notification for Seller',
                'subject' => 'Product Return Status Changed.',
                'greeting' => 'Hello',
                'message' => '<h1>Product Return Status Changed</h1><p>Product return status&nbsp;<a href="{ad_url}">{ad_name}</a>&nbsp;changed.&nbsp;</p><p>{refund_message}</p><p>Show Queue</p>'
            ],
            'de' => [
                'name' => 'Benachrichtigung über geänderten Rückerstattungsstatus für den Verkäufer',
                'subject' => 'Status der Produktrückgabe geändert.',
                'greeting' => 'Hallo',
                'message' => '<h1>Status der Produktrückgabe geändert</h1><p>Status der Produktrückgabe&nbsp;<a href="{ad_url}">{ad_name}</a>&nbsp;geändert.&nbsp;</p><p>{refund_message}</p><p>Warteschlange anzeigen</p>'
            ],
            'tr' => [
                'name' => 'Satıcı İçin Geri Ödeme Durumu Değişti Bildirimi',
                'subject' => 'Ürün İade Durumu Değiştirildi.',
                'greeting' => 'Merhaba',
                'message' => '<h1>Ürün İade Durumu Değiştirildi</h1><p>Ürün iade durumu&nbsp;<a href="{ad_url}">{ad_name}</a>&nbsp;değiştirildi.&nbsp;</p><p>{refund_message}</p><p>Sırayı Gösteriniz</p>'
            ],
        ],
        'refund_status_changed_for_admin' => [
            'slug' => 'refund_status_changed_for_admin',
            'en' => [
                'name' => 'Payment Status Changed Notification for Manager',
                'subject' => 'Payment Request Status Changed {ad_name}',
                'greeting' => 'Hello',
                'message' => '<h1>Product Return Status Changed.</h1><p>Product return status&nbsp;<a href="{ad_url}">{ad_name}</a>&nbsp;changed.&nbsp;</p><p>{refund_message}</p><p>Show Refund Request</p>'
            ],
            'de' => [
                'name' => 'Benachrichtigung über geänderten Zahlungsstatus für den Manager',
                'subject' => 'Zahlungsanforderungsstatus geändert {ad_name}',
                'greeting' => 'Hallo',
                'message' => '<h1>Status der Produktrückgabe geändert.</h1><p>Status der Produktrückgabe&nbsp;<a href="{ad_url}">{ad_name}</a>&nbsp;geändert.&nbsp;</p><p>{refund_message}</p><p>Rückerstattungsanforderung anzeigen</p>'
            ],
            'tr' => [
                'name' => 'Yönetici İçin Ödeme Durumu Değişti Bildirimi',
                'subject' => 'Ödeme İsteği Durumu Değiştirildi {ad_name}',
                'greeting' => 'Merhaba',
                'message' => '<h1>Ürün İade Durumu Değiştirildi.</h1><p>Ürün iade durumu&nbsp;<a href="{ad_url}">{ad_name}</a>&nbsp;değiştirildi.&nbsp;</p><p>{refund_message}</p><p>Geri Ödeme İsteğini Göster</p>'
            ],
        ],
        'added_tracking_number' => [
            'slug' => 'added_tracking_number',
            'en' => [
                'name' => 'Added Tracking Number',
                'subject' => 'Your product has been shipped.',
                'greeting' => 'Hello',
                'message' => '<h1>{ad_name} product has been shipped.</h1><p>Shipping tracking number : <strong>{tracking_number}</strong></p><p>Estimated Arrival Day : <strong>{tracking_days}</strong></p><p>Transport Detail URL : <a href="{tracking_detail_url}">View shipping status</a></p><p><a href="{order_url}">View Order Detail</a></p>'
            ],
            'de' => [
                'name' => 'Sendungsnummer hinzugefügt',
                'subject' => 'Ihr Produkt wurde versendet.',
                'greeting' => 'Hallo',
                'message' => '<h1>{ad_name} Produkt wurde versandt.</h1><p>Sendungsverfolgungsnummer : <strong>{tracking_number}</strong></p><p>Voraussichtlicher Ankunftstag : <strong>{tracking_days}</strong></p><p>Transportdetail-URL : <a href="{tracking_detail_url}">Versandstatus anzeigen</a></p><p><a href="{order_url}">Bestelldetails anzeigen</a></p>'
            ],
            'tr' => [
                'name' => 'Eklenen Takip Numarası',
                'subject' => 'Ürününüz kargolandı.',
                'greeting' => 'Merhaba',
                'message' => '<h1>{ad_name} ürününüz kargoya verildi.</h1><p>Kargo takip numarası : <strong>{tracking_number}</strong></p><p>Tahmini Varış Günü : <strong>{tracking_days}</strong></p><p>Transport Detail URL : <a href="{tracking_detail_url}">Kargo durumunu görüntüle</a></p><p><a href="{order_url}">Sipariş Detayını görüntüle</a></p>'
            ],
        ],
        'ticket_answered_client' => [
            'slug' => 'ticket_answered_admin',
            'en' => [
                'name' => 'Your ticket was answered',
                'subject' => 'Dear {display_name} your ticket #{ticket_number} was answered',
                'greeting' => 'Hello',
                'message' => '<p>Dear {display_name}</p> <p>Your ticket was answered.</p> <p>&nbsp;</p> <p>please check your ticket.</p> <p>&nbsp;</p> <p>Ticket No: {ticket_number}<br /><br /></p> <p>If your problem is solved, if you do not have any questions, please close your ticket.</p> <p>&nbsp;</p> <p>Regards</p>'
            ],
        ],
        'ticket_answered_admin' => [
            'slug' => 'ticket_answered_client',
            'en' => [
                'name' => 'Ticket #{ticket_number} was answered',
                'subject' => 'Ticket #{ticket_number} was answered',
                'greeting' => 'Hello',
                'message' => '<p>Ticket No: {ticket_number} was answered.</p>'
            ],
        ],
        'new_ticket_opened' => [
            'slug' => 'new_ticket_opened',
            'en' => [
                'name' => 'Ticket #{ticket_number} was opened',
                'subject' => 'Ticket #{ticket_number} was opened',
                'greeting' => 'Hello',
                'message' => '<p>Ticket No: {ticket_number} was opened.</p>'
            ],
        ],
        'ticket_closed_admin' => [
            'slug' => 'ticket_closed_admin',
            'en' => [
                'name' => 'Ticket #{ticket_number} was closed',
                'subject' => 'Ticket #{ticket_number} was closed',
                'greeting' => 'Hello',
                'message' => '<p>Ticket No: {ticket_number} was closed.</p>'
            ],
        ],
        'ticket_closed_client' => [
            'slug' => 'ticket_closed_client',
            'en' => [
                'name' => 'Ticket #{ticket_number} was closed',
                'subject' => 'Dear {display_name} your ticket #{ticket_number} was closed',
                'greeting' => 'Hello',
                'message' => '<p>Dear {display_name}</p> <p>&nbsp;</p> <p>Your ticket was closed.</p> <p>&nbsp;</p> <p>Ticket No: {ticket_number}</p> <p><br /><br />Regards</p>'
            ],
        ]
    ];

    /**
     * Run the seeder.
     */
    public function run()
    {
        foreach ($this->templates as $key => $template) {
            if (!$this->templateRepository->findBySlug($key)){
                $template['enabled'] = true;
                $template['stream'] = null;
                $template['view'] = null;
                $this->templateRepository->newQuery()->create($template);
                $this->command->info($key . ' notification template created...');
            }
        }

        $installed_modules = app('module.collection')->installed();
        $installed_modules = $installed_modules->merge(app('extension.collection')->installed());
        $installed_modules = $installed_modules->merge(app('theme.collection'));

        foreach ($installed_modules as $item) {

            $class = $item->getTransformedClass() . '\NotificationSeeder\NotificationSeeder';

            if (class_exists($class))
                $this->call($class);
        }
    }
}
