<?php

namespace Visiosoft\NotificationsModule\Listeners;

use Illuminate\Support\Facades\Notification;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\TicketsModule\Ticket\Event\NewTicketEmailEvent;

class NewTicketEmailListener
{
    private $template;

    public function __construct(TemplateRepositoryInterface $templateRepository)
    {
        $this->template = $templateRepository;
    }

    public function handle(NewTicketEmailEvent $event)
    {
        $template = $this->template->findBySlug('new_ticket_opened');
        $ticket = $event->getTicket();
        $mail_params = [
            'ticket_number' => $ticket->ticket_number,
        ];

        if ($template) {
            Notification::send(get_admins(), new MailTemplate($template->getTemplateForArray($mail_params)));
        }
    }
}