<?php namespace Visiosoft\NotificationsModule\Template;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Support\Str;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class TemplateSeeder extends Seeder
{

    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->template->create([
            'en' => [
                'message' => '<p><strong>&nbsp;Your post <a href="{url}" target="_blank">{name}</a> has been created successfully.</strong></p>',
                'name' => 'Created Ad',
                'greeting' => 'Hi',
                'subject' => 'Created Ad'
            ],
            'stream' => 'advs',
            'slug' => Str::slug('Created Ad', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<p><strong>Your ad for&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;has been approved.</strong></p>',
                'name' => 'Approved Ad',
                'greeting' => 'Hi',
                'subject' => 'Approved Ad'
            ],
            'stream' => 'advs',
            'slug' => Str::slug('Approved Ad', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Your <a href="{url}" target="_blank">{name}</a>&nbsp;ad was rejected because it does not comply with the posting rules.</strong></p>',
                'name' => 'Declined Ad',
                'greeting' => 'Hi',
                'subject' => 'Declined Ad'
            ],
            'stream' => 'advs',
            'slug' => Str::slug('Declined Ad', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>You must confirm your <a href="{url}" target="_blank">{name}</a>&nbsp;posting to be published.</strong></p>',
                'name' => 'Pending User Ad',
                'greeting' => 'Hi',
                'subject' => 'Pending User Ad'
            ],
            'stream' => 'advs',
            'slug' => Str::slug('Pending User Ad', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Your <a href="{url}" target="_blank">{name}</a> post is checked by our editors.</strong></p>',
                'name' => 'Pending Ad',
                'greeting' => 'Hi',
                'subject' => 'Pending Ad'
            ],
            'stream' => 'advs',
            'slug' => Str::slug('Pending Ad', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Your membership is activated.<br>Email:{email}</strong></p>',
                'name' => 'Registered User',
                'greeting' => 'Hi {first_name}',
                'subject' => 'Your Membership Has Been Successfully Created!'
            ],
            'stream' => 'users',
            'slug' => Str::slug('Registered User', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>You have an upcoming reservation!<br>Location:{location}<br>Service:{service}<br>Staff:{staff}<br>Date:{date}</strong></p>',
                'name' => 'Reminding Tomorrow Booking',
                'greeting' => 'Hi {name}',
                'subject' => 'You have an upcoming reservation!'
            ],
            'stream' => 'booking',
            'slug' => Str::slug('Reminding Tomorrow Booking', '_')
        ]);



        // Openclassify Templates
        $this->template->create([
            'en' => [
                'message' => '<tr>
                                    <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                        <table width="100%" cellspacing="0" cellpadding="0">
                                            <tbody>
                                            <tr>
                                                <td class="esd-container-frame" width="560" valign="top" align="center">
                                                    <table width="100%" cellspacing="0" cellpadding="0">
                                                        <tbody>
                                                        <tr>
                                                            <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                <h2><strong>About Covid-19</strong></h2>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="esd-block-text es-p20t" align="left">
                                                                <p style="color: #707070;">Hi user,</p>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="esd-block-text es-p15t" align="left">
                                                                <p style="color: #707070;">Sağlığınızı önemsiyoruz!<br>Hassas günlerden geçtiğimiz bu dönemde, kendinin ve çevrendekilerin sağlığını düşünüyoruz. Bu dönemde bizlerden almış olduğunuz hizmette bir aksama veya gecikme yaşanmayacağını belirtir, hassas bir şekilde çalışmalarımızın devam ettiğini bilmenizi isteriz.</p>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="esd-block-text es-p15t" align="left">
                                                                <p style="color: #707070;">Koronavirüs (COVID-19) salgınının yayılmasını engellemek için sosyal izolasyonun önemini hatırlatarak sağlıklı günler dileriz.</p>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="esd-block-text es-p20t" align="left">
                                                                <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                    <tbody>
                                                                    <tr>
                                                                        <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                    </tr>
                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>',
                'name' => 'General Layout',
                'subject' => 'General Layout | Openclassify.com'
            ],
            'slug' => Str::slug('General Layout', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p40b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2 style="font-size: 26px;"><strong>10% Discount on All Modules</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">The module you need is waiting for you with its discounted price.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="194" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="174" class="es-m-p0r es-m-p20b esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/87661596546265384.png" alt style="display: block;" width="174"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                                 <td class="es-hidden" width="20"></td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="173" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="173" class="es-m-p20b esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/90601596546277490.png" alt style="display: block;" width="173"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="173" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="173" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/57131596546288213.png" alt style="display: block;" width="173"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p10t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="194" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="174" class="es-m-p0r es-m-p20b esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/41001596546304817.png" alt style="display: block;" width="174"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                                 <td class="es-hidden" width="20"></td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="173" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="173" class="es-m-p20b esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/55601596546312625.png" alt style="display: block;" width="173"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="173" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="173" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_77526a037d1e45d366bab7d95c1ea7ee/images/36601596546319934.png" alt style="display: block;" width="173"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p35t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-button es-p10"><span class="es-button-border" style="background: #ffb600; border-radius: 4px; border-bottom-width: 0px;"><a href class="es-button" target="_blank" style="background: #ffb600; border-color: #ffb600; border-radius: 4px; font-size: 16px; border-width: 10px 35px;">SHOP NOW</a></span></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="60"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Discount',
                'subject' => 'Discount | Openclassify.com'
            ],
            'slug' => Str::slug('Discount', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2 style="font-size: 26px;"><strong>Welcome to openclassify</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">İndustry\'s&nbsp;make a type specimen book. It has survived not only five centuries, but also&nbsp;electronic typesetting, remaining essentially unchanged. It was populrised in the 1960&nbsp;containing Lorem Ipsum passages, and more recently.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="29"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-button es-p10"><span class="es-button-border" style="border-bottom-width: 0px; background: #ffb600; border-radius: 4px;"><a href class="es-button" target="_blank" style="background: #ffb600; border-color: #ffb600; border-radius: 4px; font-size: 16px;">LOREM IPSUM THERE</a></span></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'New User Welcome',
                'subject' => 'Welcome | Openclassify.com'
            ],
            'stream' => 'users',
            'slug' => Str::slug('New User Welcome', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Openclassify Has Published 2 New Modules!</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Yayınlanan yeni modüller ile hemen tanışın.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="22"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p40t es-p20r es-p20l" align="left" bgcolor="#ffb600" style="background-color: #ffb600; border-radius: 70px 70px 0 0; border-collapse: separate;">
                                         <!--[if mso]><table  width="560" cellpadding="0" cellspacing="0"><tr><td width="107" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="107" class="es-m-p0r esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-image es-m-p0 es-m-txt-c" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_12a6c1bb31cfa2b1280c9c688e9e4290/images/42701596533172501.png" alt style="display: block;" width="90"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="15"></td><td width="438" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="438" class="esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr class="es-mobile-hidden">
                                                             <td align="center" class="esd-block-spacer" height="25"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text">
                                                                 <p style="line-height: 150%;"><span style="color: #ffffff;"><strong><span style="font-size: 23px; line-height: 150%;">Algoia Search Integration</span></strong></span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p25t es-p40r es-p40l" align="left" bgcolor="#ffb600" style="background-color: #ffb600;">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="520" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-l">
                                                                 <h2>Algoia Search Integration<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-p15t">
                                                                 <p>Where been&nbsp;are the industry\'s standard. Lorem Ipsum is simply dummy text of the&nbsp;been worked the industry printing and industry. Has been worked the industry\'s standard dummy text ever as Ipsum&nbsp;<br>since the 1500s when.&nbsp;<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-p10t">
                                                                 <p style="font-size: 20px;"><strong>$590</strong></p>
                                                                 <p style="display: none;"><br></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20r es-p20l" align="left" bgcolor="#ffb600" style="background-color: #ffb600;">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 1px solid #e5a300; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p15t es-p20r es-p20l" align="left" bgcolor="#ffb600" style="background-color: #ffb600;">
                                         <!--[if mso]><table  width="560" cellpadding="0" cellspacing="0"><tr><td width="107" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="107" class="es-m-p0r esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-image es-m-p0 es-m-txt-c" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_12a6c1bb31cfa2b1280c9c688e9e4290/images/30511596540466287.png" alt style="display: block;" width="90"></a></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="15"></td><td width="438" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="438" class="esd-container-frame" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr class="es-mobile-hidden">
                                                             <td align="center" class="esd-block-spacer" height="31"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text">
                                                                 <p style="line-height: 150%;"><span style="color: #ffffff;"><strong><span style="font-size: 23px; line-height: 150%;">Algoia Search Integration</span></strong></span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p25t es-p40b es-p40r es-p40l" align="left" bgcolor="#ffb600" style="background-color: #ffb600; border-radius: 0 0 70px 70px; border-collapse: separate;">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="520" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-l">
                                                                 <h2>Algoia Search Integration<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-p15t">
                                                                 <p>Where been&nbsp;are the industry\'s standard. Lorem Ipsum is simply dummy text of the&nbsp;been worked the industry printing and industry. Has been worked the industry\'s standard dummy text ever as Ipsum&nbsp;<br>since the 1500s when.&nbsp;<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-p10t">
                                                                 <p style="font-size: 20px;"><strong>$590</strong></p>
                                                                 <p style="display: none;"><br></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-button es-p20t es-p25b es-p10r es-p10l"><span class="es-button-border" style="border-color: #2cb543; background: #ffffff; border-radius: 4px; border-width: 0px;"><a href class="es-button" target="_blank" style="background: #ffffff; border-color: #ffffff; color: #ffcc33; border-radius: 4px; font-size: 16px; border-width: 10px 20px; font-weight: normal;">SHOP NOW</a></span></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="19"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Newsletter',
                'subject' => 'Newsletter | Openclassify.com'
            ],
            'slug' => Str::slug('Newsletter', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Fiyat Teklifi</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Talebinize istinaden proje fiyat teklifimiz ekteki dosyadadır. Hazırlanacak olan web siteniz mobil uyumlu/ seo uyumlu/ bulut sunucu teknolojisine entegre/ konforlu bir yönetim paneline ve merkezi sistemde çalışan bir yazılım altyapısındadır.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Offer',
                'subject' => 'Offer | Openclassify.com'
            ],
            'slug' => Str::slug('Offer', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2 style="font-size: 26px;"><strong>Forgot your password?</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Don\'t worry! Reseting you password is easy. Just type in the email you registered to&nbsp;openclassify.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070; font-size: 16px;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="29"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-button es-p10"><span class="es-button-border" style="border-bottom-width: 0px; background: #ffb600; border-radius: 4px;"><a href class="es-button" target="_blank" style="background: #ffb600; border-color: #ffb600; border-radius: 4px; font-size: 16px;">CHANGE PASSWORD</a></span></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text">
                                                                 <p style="font-size: 11px; color: #707070;">Did you remember&nbsp;your password?&nbsp;<a target="_blank" style="font-size: 11px; ">Try logging in</a></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Password Forget',
                'subject' => 'Forgot Your Password | Openclassify.com'
            ],
            'stream' => 'users',
            'slug' => Str::slug('Password Forget', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Your payment failed</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Lorem Ipsum is simply dummy text of the printing and industry.&nbsp;<br>Has been worked the industry\'s standard dummy text ever since the 1500s when.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image es-p30b" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_94690ce1fab16e20c24e1c60d386e3ae/images/80711596544869547.png" alt style="display: block;"></a></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text es-p20b">
                                                                 <h1>Order Details<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h1>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-text">
                                                                 <p style="color: #d11406; font-size: 24px;">Faulty Card</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-text"><span style="color: #555554; font-size: 40px;"></span>
                                                                 <p style="color: #989898;">please try again</p>
                                                                 <p style="display: none;">&nbsp;</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="60"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Payment Failed',
                'subject' => 'Payment Failed | Openclassify.com'
            ],
            'stream' => 'orders',
            'slug' => Str::slug('Payment Failed', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Payment pending email</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Lorem Ipsum is simply dummy text of the printing and industry.&nbsp;<br>Has been worked the industry\'s standard dummy text ever since the 1500s when.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image es-p30b" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_bd08215a87ce65fea1d1e7899063669a/images/86711596544653061.png" alt style="display: block;"></a></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text es-p25b">
                                                                 <h1>Order Details<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h1>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="20"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text">
                                                                 <p><span style="color: #555554; font-size: 40px;">1,609‬ $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="71"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Payment Pending',
                'subject' => 'Payment Pending | Openclassify.com'
            ],
            'stream' => 'orders',
            'slug' => Str::slug('Payment Pending', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Your payment has been processed</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Lorem Ipsum is simply dummy text of the printing and industry.&nbsp;<br>Has been worked the industry\'s standard dummy text ever since the 1500s when.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-text es-p15b">
                                                                 <h1>Payment Details<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h1>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="24"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text">
                                                                 <p><span style="color: #555554; font-size: 40px;">1,609‬ $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-button es-p40t es-p10b es-p10r es-p10l"><span class="es-button-border" style="border-width: 0px; border-color: #2cb543; background: #ffb600; border-radius: 4px;"><a href class="es-button" target="_blank" style="background: #ffb600; border-color: #ffb600; border-radius: 4px; font-size: 16px;">PAY NOW</a></span></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="71"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Payment Reminder',
                'subject' => 'Payment Reminder | Openclassify.com'
            ],
            'stream' => 'orders',
            'slug' => Str::slug('Payment Reminder', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Your payment has been processed</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Lorem Ipsum is simply dummy text of the printing and industry.&nbsp;<br>Has been worked the industry\'s standard dummy text ever since the 1500s when.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image es-p30b" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_0c26836b611cce1fb928d2ae6a88717b/images/71891596543538047.png" alt style="display: block;"></a></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text es-p25b">
                                                                 <h1>Order Details<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h1>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="20"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text">
                                                                 <p><span style="color: #555554; font-size: 40px;">1,609‬ $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="71"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Payment Success',
                'subject' => 'Payment Success | Openclassify.com'
            ],
            'stream' => 'orders',
            'slug' => Str::slug('Payment Success', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Free Usage For 3 Months</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Openclassify ı 3 ay ücretsiz kullanmak için bizi referans olarak göstermen yeterli olacaktır. Referansın ile gelen kullanıcılar için ayrıca openclassify modüllerinde indirim fırsatından da yararlanabilirsin.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="40"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-image" style="font-size: 0px;"><a target="_blank"><img class="adapt-img" src="https://hnmyrc.stripocdn.email/content/guids/CABINET_0eec0198a32138f799a69ff00115f284/images/38801596545998067.png" alt style="display: block;" width="560"></a></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="51"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Referral',
                'subject' => 'Referral | Openclassify.com'
            ],
            'slug' => Str::slug('Referral', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Renewal Reminder</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t es-p15b" align="left">
                                                                 <p style="color: #707070;">Thank you for choosing Openclassify for your website&nbsp;<a href="https://my.stripo.email/cabinet/#">https://demo.openclassify.com</a></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t es-p15b" align="left">
                                                                 <p style="color: #000000;">As a friendly reminder, your account will . renewed for $96.00 on January 22, 2015. If you wish to keep your account with us, no action is required.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Thank you in advance,<br>Visiosoft ltd.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer es-p20" style="font-size:0">
                                                                 <table border="0" width="100%" height="100%" cellpadding="0" cellspacing="0">
                                                                     <tbody>
                                                                     <tr>
                                                                         <td style="border-bottom: 0px solid #cccccc; background: none; height: 1px; width: 100%; margin: 0px;"></td>
                                                                     </tr>
                                                                     </tbody>
                                                                 </table>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                'name' => 'Renewal Reminder',
                'subject' => 'Renewal Reminder | Openclassify.com'
            ],
            'slug' => Str::slug('Renewal Reminder', '_')
        ]);






        $this->template->create([
            'en' => [
                'message' => '<p><strong>A New Find House Application Was Created By {name}</strong></p><p>Cell Phone: {cell_phone}</p><p>E-Mail Address: {email}</p>',
                'name' => 'Find House',
                'greeting' => 'Hello',
                'subject' => 'Find House'
            ],
            'slug' => 'find_house'
        ]);

        $this->template->create([
            'en' => [
                'message' => '<p class="text-center">#{order_id} Order Created!</p>
<p><br></p>
<p class="text-center">{items}</p>
<p><br></p>
<p class="text-center">Delivery Address: {delivery}</p>
<p><br></p>
<p class="text-center">Billing Address: {billing}</p>
<p><br></p>
<p class="text-center"><a href="{url}" target="_blank">Show Order Detail</a></p>
<p><br></p>',
                'name' => 'Order Created!',
                'greeting' => 'Hi',
                'subject' => '#{order_id} Order Created!'
            ],
            'stream' => 'orders',
            'slug' => 'order_created'
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>You have a new message from {name}</strong></p><p>Message: {message}</p>',
                'name' => 'Message Notification',
                'greeting' => 'Hello',
                'subject' => 'You have a new message'
            ],
            'stream' => 'messages',
            'slug' => 'message_notification'
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>You sent a message to {name}</strong></p>
<p>Message: {message}</p>',
                'name' => 'Sender Message Notification',
                'greeting' => 'Hi',
                'subject' => 'You sent a message'
            ],
            'stream' => 'messages',
            'slug' => 'sender_message_notification'
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Your password has been changed</strong></p>',
                'name' => 'Password Changed',
                'greeting' => 'Hi',
                'subject' => 'Password changed'
            ],
            'stream' => 'users',
            'slug' => 'password_changed'
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p>Brand Name: {brand_name}</p>
<p>Sector: {sector}
</p>
<p>Sub Sector: {sub_sector}
</p>
<p>Establishment Date: {establishment_date}
</p>
<p>Authority First Name / Last Name: {authority_name}
</p>
<p>Authority Email: {authority_email}
</p>
<p>Authority Phone: {authority_phone}
</p>
<p>Website Address: {website_address}
</p>
<p>Number of Branches: {no_of_branches}
</p>
<p>Target Regions: {target_regions}
</p>
<p>Minimum m2 Requirements: {min_m2_requirements}
</p>
<p>Franchise Fee: {franchise_fee}
</p>
<p>Franchise Fee Currency: {franchise_fee_currency}
</p>
<p>CRO Share: {cro_share}
</p>
<p>Total Investment Amount: {total_investment_amount}
</p>
<p>Total Investment Amount Currency: {total_investment_amount_currency}
</p>
<p>Education Support: {education_support}</p>',
                'name' => 'Franchisor Brand Information Form',
                'greeting' => 'Hello',
                'subject' => 'Franchisor Brand Information Form'
            ],
            'slug' => 'franchisor_brand_information_form'
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p>Company Name: {company_name}
</p>
<p>Sector: {sector}
</p>
<p>Service Details: {service_details}</p>
<p>Contact Email: {contact_email}
</p>
<p>Contact Phone: {contact_phone}
</p>
<p>Website Address: {website_address}</p>',
                'name' => 'Solution Partner Information Form',
                'greeting' => 'Hello',
                'subject' => 'Solution Partner Information Form'
            ],
            'slug' => 'solution_partner_information_form'
        ]);

    }
}
