<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Notification;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\OrdersModule\Events\OrderCreated;

class OrderCreatedMail
{
    private $template;
    private $user;
    private $roleRepository;

    public function __construct(
        RoleRepositoryInterface $roleRepository,
        UserRepositoryInterface $user,
        TemplateRepositoryInterface $template)
    {
        $this->roleRepository = $roleRepository;
        $this->template = $template;
        $this->user = $user;
    }

    public function handle(OrderCreated $event)
    {
        $order = $event->getOrder();
        $user = $this->user->find($order->user_id);

        $adminRole = $this->roleRepository->findBySlug('admin');
        $admins = $adminRole->getUsers();
        $users = $admins->add($user);

        $mail_params = [
            'display_name' => $user->name(),
            'url' => route('orders::purchase_detail', ['id' => $order->id]),
            'order_id' => $order->id
        ];

        if ($template = $this->template->findBySlug('order_created')) {
            Notification::send($users, new MailTemplate($template->getTemplateForArray($mail_params)));
        }
    }
}
