<?php namespace Visiosoft\NotificationsModule\Template;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\NotificationsModule\Template\Contract\TemplateInterface;
use Anomaly\Streams\Platform\Model\Notifications\NotificationsTemplateEntryModel;

class TemplateModel extends NotificationsTemplateEntryModel implements TemplateInterface
{
    public function getTemplate($ad)
    {
        $template = $this->toArray();
        $template['message'] = str_replace('{url}', $this->createAdLink($ad), $template['message']);
        $template['message'] = str_replace('{name}', $ad->name, $template['message']);
        $template['message'] = str_replace('{id}', $ad->id, $template['message']);

        $template['subject'] = str_replace('{url}', $this->createAdLink($ad), $template['subject']);
        $template['subject'] = str_replace('{name}', $ad->name, $template['subject']);
        $template['subject'] = str_replace('{id}', $ad->id, $template['subject']);

        return $template;
    }

    public function createAdLink($ad)
    {
        $adModel = new AdvModel();
        return $adModel->getAdvDetailLinkByModel($ad, 'list');
    }
}
