<?php namespace Visiosoft\NotificationsModule\Template\TestMailForm;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Visiosoft\NotificationsModule\Template\TemplateModel;

class TestMailFormBuilder extends FormBuilder
{

    protected $fields = [
        'template' => [
            'type' => 'anomaly.field_type.relationship',
            'required' => true,
            'config' => [
                'related' => TemplateModel::class,
            ],
        ],
        'email' => [
            'type' => 'anomaly.field_type.email',
            'required' => true,
            'config' => [
                'default_value' => 'info@openclassify.com',
            ],
        ],
    ];

    protected $buttons = [
        'cancel',
    ];

    protected $options = [
        'redirect' => '/admin/notifications/template',
        'success_message' => 'visiosoft.module.notifications::message.success_test_message',
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
