<?php namespace Visiosoft\NotificationsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Carbon;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Adv\Event\AdRemainingCheck;

class MailNotifyController extends PublicController
{
    protected $advs_repository;
    protected $advs_model;
    protected $userRepository;

    public function __construct(
        AdvRepositoryInterface $advRepository,
        AdvModel $advModel,
        UserRepositoryInterface $userRepository
    )
    {
        $this->advs_repository = $advRepository;
        $this->advs_model = $advModel;
        $this->userRepository = $userRepository;
    }

    public function checkAdRemainingTime() {

        $user_ads = $this->advs_model->newQuery()
            ->where('advs_advs.status', 'approved')
            ->whereBetween('finish_at', [Carbon::now(), Carbon::now()->addDays(setting_value('visiosoft.module.notifications::mail_last_days'))])
            ->get()->groupBy('created_by_id');


        foreach ($user_ads as $key => $ads) {
            $user = $this->userRepository->find($key);
            if ($user) {
                foreach ($ads as $ad){
                    $ad->update([
                        'notificated_at' => Carbon::now()
                    ]);
                }
                event(new AdRemainingCheck($user));
            }
        }
    }
}