<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreated;

class CreatedSubscriptionMail
{

    private $template;
    private $log;

    public function __construct(TemplateRepositoryInterface $templateRepository, LogRepositoryInterface $logRepository)
    {
        $this->template = $templateRepository;
        $this->log = $logRepository;
    }

    public function handle(SubscriptionCreated $event)
    {
        $user = $event->getUser();
        $subscription = $event->getSubscription();

        $template = $this->template->findBySlug('created_subscription');

        $mail_params = [
            'display_name' => $user->display_name,
            'subscription_name' => $subscription->plan->name,
        ];

        if (!is_null($template)) {
            $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
            $this->log->createLog($user->email, $template['subject'], $template['message'], $template['greeting'], $subscription);
        }
    }
}
