<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionRemaining;

class SubscriptionRemainingMail
{

    private $template;

    public function __construct(TemplateRepositoryInterface $templateRepository)
    {
        $this->template = $templateRepository;
    }

    public function handle(SubscriptionRemaining $event)
    {
        $user = $event->getSubscription()->assign;
        $subscription = $event->getSubscription();

        $template = $this->template->findBySlug("subscription_remaining");

        $sites = array();
        foreach ($event->getSites() as $site) {
            $sites[] = $site->subdomain_name . "." . $site->type;
        }

        $mail_params = [
            'display_name' => $user->display_name,
            'plan_name' => $subscription->plan->name,
            'remaining' => $event->getRemaining(),
            'sites' => implode(',', $sites),
        ];

        if (!is_null($template)) {
            $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
        }
    }
}
