<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreated;

class CreatedSubscriptionMail
{

    private $template;

    public function __construct(TemplateRepositoryInterface $templateRepository)
    {
        $this->template = $templateRepository;
    }

    public function handle(SubscriptionCreated $event)
    {
        $user = $event->getSubscription()->assign;
        $subscription = $event->getSubscription();

        $template_slug = "created_subscription";
        if($event->getType() == "manuel")
        {
            $template_slug = "created_subscription_on_manuel";
        }
        $template = $this->template->findBySlug($template_slug);

        $mail_params = [
            'display_name' => $user->display_name,
            'subscription_name' => $subscription->plan->name,
        ];

        if (!is_null($template)) {
            $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
        }
    }
}
