<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Event\ChangedStatusAd;
use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class ChangeStatusAdMail
{
    private $ad;
    private $template;
    private $log;
    private $user;

    public function __construct(
        AdvModel $ad,
        LogRepositoryInterface $log,
        UserRepositoryInterface $user,
        TemplateRepositoryInterface $template)
    {
        $this->ad = $ad;
        $this->template = $template;
        $this->log = $log;
        $this->user = $user;
    }

    public function handle(ChangedStatusAd $event)
    {
        $ad = $event->getAdDetail();
        $user = $this->user->find($ad->created_by_id);
        if ($ad->status == "approved") {
            $template = $this->template->findBySlug('approved_ad')->getTemplate($ad);
        } elseif ($ad->status == "declined") {
            $template = $this->template->findBySlug('declined_ad')->getTemplate($ad);
        } elseif ($ad->status == "pending_user") {
            $template = $this->template->findBySlug('pending_user_ad')->getTemplate($ad);
        } else {
            $template = $this->template->findBySlug('pending_ad')->getTemplate($ad);
        }
        $user->notify(new MailTemplate($template));
        $this->log->createLog($user->getEmail(), $template['subject'], $template['message'], $template['greeting'], $ad);
    }
}
