<?php namespace Visiosoft\NotificationsModule\Template;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class TemplateSeeder extends Seeder
{

    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınız başarıyla oluşturuldu.</strong></p>',
                'name' => 'Created Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Created Ad'
            ],
            'slug' => str_slug('Created Ad')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınız onaylandı.</strong></p>',
                'name' => 'Approved Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Approved Ad'
            ],
            'slug' => str_slug('Approved Ad')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınız ilan verme kurallarına uymadığı için reddedilmiştir.</strong></p>',
                'name' => 'Declined Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Declined Ad'
            ],
            'slug' => str_slug('Declined Ad')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınızı yayınlanması için onaylamanız gerekmektedir.</strong></p>',
                'name' => 'Pending User Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Pending User Ad'
            ],
            'slug' => str_slug('Pending User Ad')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınız editörlerimiz tarafından kontrol edilmektedir.</strong></p>',
                'name' => 'Pending Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Pending Ad'
            ],
            'slug' => str_slug('Pending Ad')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Üyeliğiniz aktifleştirilmiştir.<br>Email:{email}<br>Username:{username}</strong></p>',
                'name' => 'Registered User',
                'greeting' => 'Merhaba {first_name}',
                'subject' => 'Üyeliğiniz Başarıyla Oluşturuldu!'
            ],
            'slug' => str_slug('Registered User')
        ]);
    }
}
