<?php namespace Visiosoft\NotificationsModule\Log;

use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class LogRepository extends EntryRepository implements LogRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var LogModel
     */
    protected $model;

    /**
     * Create a new LogRepository instance.
     *
     * @param LogModel $model
     */
    public function __construct(LogModel $model)
    {
        $this->model = $model;
    }

    public function createLog($email, $subject, $message, $greeting = null, $entry = null)
    {
        $log = $this->create([
            'email' => $email,
            'message' => $message,
            'subject' => $subject,
        ]);

        if (!is_null($entry)) {
            $log->entry = $entry;
            $log->save();
        }
        if (!is_null($greeting)) {
            $log->greeting = $greeting;
            $log->save();
        }
    }
}
