<?php namespace Visiosoft\NotificationsModule\Notify\Notification;

use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class SendDemandMail extends Notification implements ShouldQueue
{

    use Queueable;

    private $content;
    private $url;

    public function __construct($content, $url)
    {
        $this->content = $content;
        $this->url = $url;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->view('visiosoft.theme.emlak24::notifications/email', [
                'content' => $this->content,
                'url' => $this->url
            ]);
    }
}
