<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\DemandModule\Demand\Events\CreateDemand;
use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Notify\Notification\SendDemandMail;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class CreateDemandMail
{

    private $templateRepository;
    private $logRepository;
    private $userRepository;

    public function __construct(
        TemplateRepositoryInterface $templateRepository,
        LogRepositoryInterface $logRepository,
        UserRepositoryInterface $userRepository
    )
    {
        $this->templateRepository = $templateRepository;
        $this->logRepository = $logRepository;
        $this->userRepository = $userRepository;
    }

    public function handle(CreateDemand $event)
    {
        $admin = $this->userRepository->find(1);
        $user = $event->user();
        $demand = $event->demand();

        $templates = [
            'adminTemplate' => $this->templateRepository->findBySlug('create_demand_admin'),
            'userTemplate' => $this->templateRepository->findBySlug('create_demand_user'),
        ];
        foreach ($templates as $key => $template) {
            if (!is_null($template)) {
                $content = $template->message;
                $content = str_replace('{emlak24_url}', url('/'), $content);
                $content = str_replace('{name}', $user->name(), $content);
                $content = str_replace('{request_id}', $demand['id'], $content);
                $url = url('/');

                if ($key === 'userTemplate') {
                    $user->notify(new SendDemandMail($content, $url));
                    $this->logRepository->createLog($user->email, $template['subject'], $template['message'], $template['greeting']);
                } else {
                    $demandLink = $demand['type'] === 'service' ?
                        url('admin/demand/services/edit/' . $demand['id']) :
                        url('admin/demand/edit/' . $demand['id']);
                    $content = str_replace('{demand_link}', $demandLink, $content);

                    $admin->notify(new SendDemandMail($content, $url));
                    $this->logRepository->createLog($admin->email, $template['subject'], $template['message'], $template['greeting']);
                }
            }
        }
    }
}
