<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\webhook\SubscriptionRenewedForWebhook;

class RenewedSubscriptionForWebhookMail
{

    private $template;
    private $siteRepository;

    public function __construct(TemplateRepositoryInterface $templateRepository, SiteRepositoryInterface $siteRepository)
    {
        $this->template = $templateRepository;
        $this->siteRepository = $siteRepository;
    }

    public function handle(SubscriptionRenewedForWebhook $event)
    {
        if ($user = $event->getSubscription()->assign) {
            $subscription = $event->getSubscription();

            $sites = $this->siteRepository->getSiteForSubscription($subscription->id);
            $siteNames = '';
            foreach ($sites as $site) {
                $siteNames .= $site->subdomain_name . '.' . $site->type;
            }
            $template = $this->template->findBySlug(str_slug('Renewed Subscription For Paddle', '_'));

            if (!is_null($template) && !is_null($subscription->plan)) {
                $mail_params = [
                    'display_name' => $user->display_name,
                    'subscription_name' => $subscription->plan->name . ' '
                        . $subscription->plan->interval . ' '
                        . $subscription->plan->interval_period . ' (' . $siteNames . ')',
                ];
                $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
            }
        }
    }
}
