<?php namespace Visiosoft\NotificationsModule\Notify\Notification;

use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;


class CreateBookingMail extends Notification implements ShouldQueue
{

    use Queueable;


    private $detail;
    private $location;
    private $service;
    private $to;

    /**
     * CreateBookingMail constructor.
     * @param $detail
     * @param $location
     * @param $service
     * @param null $to
     */
    public function __construct($detail, $location, $service, $to = null)
    {
        $this->detail = $detail;
        $this->location = $location;
        $this->service = $service;
        $this->to = $to;
    }

    /**
     * @param UserInterface $notifiable
     * @return array
     */
    public function via(UserInterface $notifiable)
    {
        return ["mail"];
    }

    /**
     * @param UserInterface $notifiable
     * @return MailMessage
     */
    public function toMail(UserInterface $notifiable)
    {
        if ($this->to != null)
            $notifiable->email = $this->to;

        return (new MailMessage())
            ->view('visiosoft.module.notifications::notification')
            ->subject(setting_value('visiosoft.module.booking::mail_subject'))
            ->greeting(trans('visiosoft.module.notifications::notification.hi_message') . $this->detail->name)
            ->line(setting_value('visiosoft.module.booking::mail_message'))
            ->line('<hr>')
            ->line('Date : ' . $this->detail->booking_datetime_start . " - " . $this->detail->booking_datetime_end)
            ->line('Location : ' . $this->location->name)
            ->line('Service : ' . $this->service->name)
            ->line('Staff : ' . $this->detail->staff->name)
            ->line('<hr>')
            ->line('Phone : ' . $this->detail->phone)
            ->line('Email : ' . $this->detail->email)
            ->line('Payment Type: ' . $this->detail->payment_type)
            ->line('Payment : ' . $this->detail->payment_status)
            ->salutation(trans('visiosoft.module.notifications::notification.thanks_message'))
            ->action(setting_value('visiosoft.module.booking::mail_button_text'), url('/booking/detail/' . $this->detail->id));
    }
}
