<?php namespace Visiosoft\NotificationsModule\Notify\Notification;

use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;


class ActivationBookingMail extends Notification implements ShouldQueue
{
    use Queueable;

    private $detail;

    /**
     * CreateBookingMail constructor.
     * @param $detail
     */
    public function __construct($detail)
    {
        $this->detail = $detail;
    }

    /**
     * @param UserInterface $notifiable
     * @return array
     */
    public function via(UserInterface $notifiable)
    {
        return ["mail"];
    }

    /**
     * @param UserInterface $notifiable
     * @return MailMessage
     */
    public function toMail(UserInterface $notifiable)
    {
        $notifiable->email = $this->detail->email;

        return (new MailMessage())
            ->view('visiosoft.module.notifications::notification')
            ->subject(setting_value('visiosoft.module.booking::activation_mail_subject'))
            ->greeting(trans('visiosoft.module.notifications::notification.hi_message') . $this->detail->name)
            ->line('<hr>')
            ->line(setting_value('visiosoft.module.booking::activation_mail_message'))
            ->line('<h1 style="text-align: center">' . $this->detail->activation_code . "</h1>")
            ->salutation(trans('visiosoft.module.notifications::notification.thanks_message'))
            ->action(setting_value('visiosoft.module.booking::activation_mail_button_text'), url('/booking/activated?booking_id=' . $this->detail->id . "&activation_code=" . $this->detail->activation_code));
    }
}
