<?php namespace Visiosoft\NotificationsModule\Template;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class TemplateSeeder extends Seeder
{

    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınız başarıyla oluşturuldu.</strong></p>',
                'name' => 'Created Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Created Ad'
            ],
            'slug' => str_slug('Created Ad')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınız onaylandı.</strong></p>',
                'name' => 'Approved Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Approved Ad'
            ],
            'slug' => str_slug('Approved Ad')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınız ilan verme kurallarına uymadığı için reddedilmiştir.</strong></p>',
                'name' => 'Declined Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Declined Ad'
            ],
            'slug' => str_slug('Declined Ad')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınızı yayınlanması için onaylamanız gerekmektedir.</strong></p>',
                'name' => 'Pending User Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Pending User Ad'
            ],
            'slug' => str_slug('Pending User Ad')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong><a href="{url}" target="_blank">{name}</a> ilanınız editörlerimiz tarafından kontrol edilmektedir.</strong></p>',
                'name' => 'Pending Ad',
                'greeting' => 'Merhaba',
                'subject' => 'Pending Ad'
            ],
            'slug' => str_slug('Pending Ad')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Üyeliğiniz aktifleştirilmiştir.<br>Email:{email}<br>Username:{username}</strong></p>',
                'name' => 'Registered User',
                'greeting' => 'Merhaba {first_name}',
                'subject' => 'Üyeliğiniz Başarıyla Oluşturuldu!'
            ],
            'slug' => str_slug('Registered User')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Yaklaşan rezervasyonunuz var!<br>Location:{location}<br>Service:{service}<br>Staff:{staff}<br>Date:{date}</strong></p>',
                'name' => 'Reminding Tomorrow Booking',
                'greeting' => 'Merhaba {name}',
                'subject' => 'Yaklaşan rezervasyonunuz var!'
            ],
            'slug' => str_slug('Reminding Tomorrow Booking')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<h4 class="text-center">Openclassify.com hesabınız başarıyla oluşturuldu.</h4><hr><p class="text-center"><strong>Giriş Bilgileriniz</strong></p><h5 class="text-center">{email}</h5><h5 class="text-center">{password}</h5><p class="text-center"><strong><a href="{login_url}">{login_url}</a> adresinden giriş yapabilirsiniz.</strong></p><p class="text-center">Teşekkür ederiz.</p><h6 class="text-center">Openclassify Team</h6>',
                'name' => 'Openclassify User Created',
                'greeting' => 'Merhaba {display_name}',
                'subject' => 'Openclassify.com Giriş Bilgileriniz !'
            ],
            'slug' => str_slug('Openclassify User Created')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<h3 class="text-center">Openclassify.com {subscription_name} paketiniz aktif edildi.</h3><h5 class="text-center">Daha şık bir mağaza için Modüller ve Temalar sayfalarımızı ziyaret ediniz.</h5><p class="text-center">Teşekkürler.</p><h6 class="text-center">Openclassify Team</h6>',
                'name' => 'Created Subscription',
                'greeting' => 'Merhabalar {display_name}',
                'subject' => 'Openclassify.com Aboneliğiniz Başladı !'
            ],
            'slug' => str_slug('Created Subscription')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<h4 class="text-center">{site_url} sitenizin kurulumu tamamlanmıştır.</h4><hr><p class="text-center"><strong>Giriş Bilgileriniz</strong></p><h5 class="text-center">{email}</h5><h5 class="text-center">{password}</h5><p class="text-center"><strong><a href="http://oc1906.test/admin/notifications/template/edit/%7Blogin_url%7D">{login_url} adresinden giriş yapabilirsiniz.</a></strong></p><p class="text-center">Teşekkür ederiz.</p><h6 class="text-center">Openclassify Team</h6>',
                'name' => 'Created Site',
                'greeting' => 'Merhabalar {display_name}',
                'subject' => '{site_url} sitenizin kurulumu tamamlandı ! | Openclassify.com'
            ],
            'slug' => str_slug('Created Site')
        ]);
    }
}
