<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Notify\Notification\SendDemandMail;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\OffersModule\Offer\Events\SendOffer;

class SendOfferMail
{

    private $templateRepository;
    private $logRepository;

    public function __construct(TemplateRepositoryInterface $templateRepository, LogRepositoryInterface $logRepository)
    {
        $this->templateRepository = $templateRepository;
        $this->logRepository = $logRepository;
    }

    public function handle(SendOffer $event)
    {
        $offer = $event->offer();
        $password = $event->password();

        $template = $this->templateRepository->findBySlug('send_offer');
        $content = $template->message;
        $content = str_replace('{offer_link}', route('message_details', [$offer->chat->id]), $content);
        $content = str_replace('{name}', $offer->offered_to->name(), $content);
        $content = str_replace('{email}', $offer->offered_to->email, $content);
        $content = str_replace('{password}', $password, $content);
        $subject = $template->subject;
        $url = url('/');

        if (!is_null($template)) {
            $offer->offered_to->notify(new SendDemandMail($content, $subject, $url));
            $this->logRepository->createLog($offer->offered_to->email, $template['subject'], $template['message'], $template['greeting']);
        }
    }
}
