<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SiteModule\Site\Event\ActivatedSite;

class ActivatedSiteMail
{

    private $template;
    private $log;

    public function __construct(TemplateRepositoryInterface $templateRepository, LogRepositoryInterface $logRepository)
    {
        $this->template = $templateRepository;
        $this->log = $logRepository;
    }

    public function handle(ActivatedSite $event)
    {
        $site = $event->getSite();
        $user = $event->getUser();

        $template = $this->template->findBySlug('created_site');

        $mail_params = [
            'display_name' => $user->display_name,
            'email' => $user->email,
            'password' => $site->password,
            'login_url' => $site->subdomain_name . "." . $site->type . "/admin",
            'site_url' => $site->subdomain_name . "." . $site->type
        ];

        if (!is_null($template)) {
            $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
            $this->log->createLog($user->email, $template['subject'], $template['message'], $template['greeting'], $site);
        }
    }
}
