<?php namespace Visiosoft\NotificationsModule\Notify\Listener;

use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CartsModule\Cart\Event\Payment;
use Visiosoft\NotificationsModule\Notify\Notification\PaymentAdminMail;
use Visiosoft\NotificationsModule\Notify\Notification\PaymentUserMail;
use Visiosoft\NotificationsModule\Notify\NotifyModel;
use Visiosoft\NotificationsModule\Smsnotify\Event\PaymentSms;

class PaySuccess
{
    public function __construct(Dispatcher $events)
    {
        $this->events = $events;
        $this->model = new NotifyModel();
    }

    public function handle(Payment $event)
    {
        $order_id = $event->request;
        $user = $this->model->getUser(Auth::id());

        $user->notify(new PaymentUserMail($order_id,$user,$event->settings));
        if ($event->settings->value('visiosoft.module.notifications::admin_notifications') == true) {
            $user = Auth::user();
            $user->notify(new PaymentAdminMail($order_id,$user,$event->settings));
        }
        if ($event->settings->value('visiosoft.module.notifications::payment_user_sms') == true) {
            $user = Auth::user();
            $msg = $event->settings->value('visiosoft.module.notifications::payment_user_sms_msg');
            $this->events->dispatch(new PaymentSms($user,$msg));
        }
    }
}
