<?php namespace Visiosoft\NotificationsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CloudsiteModule\Site\Event\CreateSite;
use Visiosoft\CloudsiteModule\Site\Event\SendNotificationUser;
use Visiosoft\NotificationsModule\Notify\Listener\AgainPurchase;
use Visiosoft\NotificationsModule\Notify\Listener\AgainSale;
use Visiosoft\NotificationsModule\Notify\Listener\CreatedSiteNotification;
use Visiosoft\NotificationsModule\Notify\Listener\CreateSiteNotification;
use Visiosoft\NotificationsModule\Notify\Listener\last3daysNotification;
use Visiosoft\NotificationsModule\Notify\Listener\lastdayNotification;
use Visiosoft\NotificationsModule\Notify\Listener\OneMonthLaterNotification;
use Visiosoft\NotificationsModule\Notify\Listener\OneWeekLaterNotification;
use Visiosoft\NotificationsModule\Smsnotify\Contract\SmsnotifyRepositoryInterface;
use Visiosoft\NotificationsModule\Smsnotify\SmsnotifyRepository;
use Visiosoft\NotificationsModule\Smsnotify\SmsnotifyModel;
use Visiosoft\AdvsModule\Adv\Event\ChangeStatusAd;
use Visiosoft\AdvsModule\Adv\Event\CreateAd;
use Visiosoft\AdvsModule\Adv\Event\EditAd;
use Visiosoft\CartsModule\Cart\Event\Payment;
use Visiosoft\NotificationsModule\Notify\Contract\NotifyRepositoryInterface;
use Visiosoft\NotificationsModule\Notify\Listener\NewAd;
use Visiosoft\NotificationsModule\Notify\Listener\PaySuccess;
use Visiosoft\NotificationsModule\Notify\Listener\StatusAd;
use Visiosoft\NotificationsModule\Notify\Listener\UpdateAd;
use Visiosoft\NotificationsModule\Notify\NotifyRepository;
use Anomaly\Streams\Platform\Model\Notifications\NotificationsNotifyEntryModel;
use Visiosoft\NotificationsModule\Notify\NotifyModel;
use Visiosoft\SubscriptionsModule\Subscription\Event\last3days;
use Visiosoft\SubscriptionsModule\Subscription\Event\lastday;
use Visiosoft\SubscriptionsModule\Subscription\Event\OneMonthLater;
use Visiosoft\SubscriptionsModule\Subscription\Event\OneWeekLater;
use Illuminate\Routing\Router;
use Visiosoft\OrdersModule\Orderdetail\Event\AgainPuchaseOrder;
use Visiosoft\OrdersModule\Orderdetail\Event\AgainPurchaseOrder;
use Visiosoft\OrdersModule\Orderdetail\Event\AgainSaleOrder;
use Visiosoft\OrdersModule\Orderdetail\Event\PaymentOrder;
use Visiosoft\OrdersModule\Orderdetail\Event\RefundOrder;
use Visiosoft\OrdersModule\Orderdetail\Event\ReportOrder;

class NotificationsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/notifications/sms/test' => 'Visiosoft\NotificationsModule\Http\Controller\Admin\SmsnotifyController@test',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\NotificationsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\NotificationsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\NotificationsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        NotificationsSmsnotifyEntryModel::class => SmsnotifyModel::class,
        NotificationsNotifyEntryModel::class => NotifyModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        SmsnotifyRepositoryInterface::class => SmsnotifyRepository::class,
        NotifyRepositoryInterface::class => NotifyRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        if (setting_value('streams::mail_host') != null
            and setting_value('streams::mail_port') != 0
            and setting_value('streams::mail_username') != null
            and setting_value('streams::mail_password') != null) {
            $this->listeners = [
                CreateAd::class =>
                    [
                        NewAd::class,
                    ],
                EditAd::class =>
                    [
                        UpdateAd::class,
                    ],
                ChangeStatusAd::class =>
                    [
                        StatusAd::class,
                    ],
                Payment::class =>
                    [
                        PaySuccess::class,
                    ],
                AgainPurchaseOrder::class =>
                    [
                        AgainPurchase::class,
                    ],
                AgainSaleOrder::class =>
                    [
                        AgainSale::class,
                    ],
                PaymentOrder::class =>
                    [
                        \Visiosoft\NotificationsModule\Notify\Listener\PaymentOrder::class,
                    ],
                RefundOrder::class =>
                    [
                        \Visiosoft\NotificationsModule\Notify\Listener\RefundOrder::class,
                    ],
                ReportOrder::class =>
                    [
                        \Visiosoft\NotificationsModule\Notify\Listener\ReportOrder::class,
                    ],
                CreateSite::class =>
                    [
                        CreateSiteNotification::class,
                    ],
                SendNotificationUser::class =>
                    [
                        CreatedSiteNotification::class,
                    ],
                last3days::class =>
                    [
                        last3daysNotification::class,
                    ],
                lastday::class =>
                    [
                        lastdayNotification::class,
                    ],
                OneWeekLater::class =>
                    [
                        OneWeekLaterNotification::class,
                    ],
                OneMonthLater::class =>
                    [
                        OneMonthLaterNotification::class,
                    ],
            ];
        }


//        dd($this->listeners);
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
