<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SiteModule\Site\Event\installedAddon;

class InstalledAddonMail
{

    private $template;
    private $log;

    public function __construct(TemplateRepositoryInterface $templateRepository, LogRepositoryInterface $logRepository)
    {
        $this->template = $templateRepository;
        $this->log = $logRepository;
    }

    public function handle(installedAddon $event)
    {
        $site = $event->getSite();
        $user = $event->getAssign();
        $addon = $event->getAddon();

        $template = $this->template->findBySlug('installed_addon');

        $mail_params = [
            'display_name' => $user->display_name,
            'site_url' => $site->subdomain_name . "." . $site->type,
            'addon_name' => $addon
        ];

        if (!is_null($template)) {
            $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
            $this->log->createLog($user->email, $template['subject'], $template['message'], $template['greeting'], $site);
        }
    }
}
