<?php namespace Visiosoft\NotificationsModule\Template\TestMailForm;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class TestMailFormHandler
{
    public function handle(TestMailFormBuilder $builder, UserRepositoryInterface $user, TemplateRepositoryInterface $template, MessageBag $message)
    {
        if (!$builder->canSave()) {
            return;
        }
        $user = $user->first();
        $template = $template->find($builder->getPostValue('template'));

        if ($user && $template) {
            try {
                $user->notify(new MailTemplate($template->getTemplateForArray([]), $builder->getPostValue('email', 'info@openclassify.com')));
            } catch (\Exception $exception) {
                $message->error([$exception->getMessage()]);
            }
        }
    }

}
