<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Event\AdRemainingCheck;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class AdRemainingTimeMail
{
    private $ad;
    private $template;
    private $user;

    public function __construct(
        AdvModel                    $ad,
        UserRepositoryInterface     $user,
        TemplateRepositoryInterface $template)
    {
        $this->ad = $ad;
        $this->template = $template;
        $this->user = $user;
    }

    public function handle(AdRemainingCheck $event)
    {
        $user = $event->getUser();
        $mail_params = [
            'day' => setting_value('visiosoft.module.notifications::mail_last_days'),
            'url' => setting_value('streams::domain'),
        ];
        $template = $this->template->findBySlug('ad_extend_reminder');
        $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));

    }
}
