<?php namespace Visiosoft\NotificationsModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class NotificationsModuleSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run()
    {
        Model::unguard();
        DB::unprepared(file_get_contents(realpath(dirname(__DIR__)) . '/src/notification_TR.sql'));
        Model::reguard();

        $installed_modules = app('module.collection')->installed();
        $installed_modules = $installed_modules->merge(app('extension.collection')->installed());

        foreach ($installed_modules as $item) {

            $class = $item->getTransformedClass() . '\NotificationSeeder\NotificationSeeder';

            if (class_exists($class))
                $this->call($class);
        }
    }
}
