<?php

namespace Visiosoft\EmailLogWidgetExtension\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Illuminate\Support\Facades\DB;
use Laravel\Telescope\Contracts\EntriesRepository;
use Yajra\DataTables\DataTables;

class ApiController extends AdminController
{
    public function emailLogsDatatable($limit)
    {
        $formattedEntries = [];
        $entries = DB::table('telescope_entries')
            ->select(['uuid', 'content'])
            ->where('type', 'mail')
            ->limit($limit)
            ->orderBy('created_at', 'DESC')
            ->get();


        if ($entries) {
            foreach ($entries as $entry) {
                $content = json_decode($entry->content);
                $subject = '';
                if (preg_match('/Subject: (.*?)\r\n/', substr($content->raw, 0, 250), $matches)) {
                    $subject = mb_decode_mimeheader($matches[1]);
                }
                $formattedEntries[] = ['to' => key($content->to), 'subject' => $subject];
            }
        }

        return DataTables::of($formattedEntries)->toJson();
    }

}