<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class RegisteredUser
{
    private $template;
    private $log;
    private $user;

    public function __construct(
        LogRepositoryInterface $log,
        UserRepositoryInterface $user,
        TemplateRepositoryInterface $template)
    {
        $this->template = $template;
        $this->log = $log;
        $this->user = $user;
    }

    public function handle(UserHasRegistered $event)
    {
        $user = $event->getUser();
        $template = $this->template->findBySlug('registered_user')->getTemplateForArray($user->toArray());
        if (!is_null($template)) {
            $user->notify(new MailTemplate($template));
            $this->log->createLog($user->getEmail(), $template['subject'], $template['message'], $template['greeting'], $user);
        }
    }
}
