<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SiteModule\Site\Event\CreatedUserForDemo;

class CreateSiteForUserMail
{

    private $template;

    public function __construct(TemplateRepositoryInterface $templateRepository)
    {
        $this->template = $templateRepository;
    }

    public function handle(CreatedUserForDemo $event)
    {
        $site = $event->getSite();
        $user = $event->getUser();

        $template = $this->template->findBySlug(str_slug('Created User For Demo', '_'));

        $mail_params = [
            'display_name' => $user->display_name,
            'email' => $user->email,
            'password' => $site->password,
            'login_url' => url('login')
        ];

        if (!is_null($template)) {
            $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
        }
    }
}
