<?php namespace Visiosoft\NotificationsModule\Listeners;

use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\SubscriptionsModule\Subscription\Event\CreateSubscriptionOnManuel;

class CreatedSubscriptionOnManuel
{

    private $template;

    public function __construct(TemplateRepositoryInterface $templateRepository)
    {
        $this->template = $templateRepository;
    }

    public function handle(CreateSubscriptionOnManuel $event)
    {
        $subscription = $event->getSubscription();
        if ($user = $subscription->assign) {

            $template = $this->template->findBySlug(str_slug('Created Subscription On Manuel', '_'));


            if (!is_null($template) && !is_null($subscription->plan)) {
                $mail_params = [
                    'display_name' => $user->display_name,
                    'subscription_name' => $subscription->plan->name,
                ];
                $user->notify(new MailTemplate($template->getTemplateForArray($mail_params)));
            }
        }
    }
}
