<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Event\CreatedAd;
use Visiosoft\NotificationsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;

class CreatedAdMail
{
    private $ad;
    private $template;
    private $log;
    private $user;

    public function __construct(
        AdvModel $ad,
        LogRepositoryInterface $log,
        UserRepositoryInterface $user,
        TemplateRepositoryInterface $template)
    {
        $this->ad = $ad;
        $this->template = $template;
        $this->log = $log;
        $this->user = $user;
    }

    public function handle(CreatedAd $event)
    {
        $ad = $event->getAdDetail();
        $user = $this->user->find($ad->created_by_id);

        $template = $this->template->findBySlug('created_ad')->getTemplate($ad);
        if (!is_null($template)) {
            $user->notify(new MailTemplate($template));
            $this->log->createLog($user->getEmail(), $template['subject'], $template['message'], $template['greeting'], $ad);
        }
    }
}
