<?php namespace Visiosoft\NotificationsModule\Listeners;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Notification;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\OptionConfiguration\Contract\OptionConfigurationRepositoryInterface;
use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\OrdersModule\Events\OrderCreated;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;

class OrderCreatedMail
{
    private $template;
    private $user;
    private $roleRepository;
    private $advRepository;
    private $orderdetailRepository;
    private $optionConfigurationRepository;
    private $currency;

    public function __construct(
        RoleRepositoryInterface $roleRepository,
        UserRepositoryInterface $user,
        TemplateRepositoryInterface $template,
        AdvRepositoryInterface $advRepository,
        OrderdetailRepositoryInterface $orderdetailRepository,
        OptionConfigurationRepositoryInterface $optionConfigurationRepository,
        Currency $currency
    )
    {
        $this->roleRepository = $roleRepository;
        $this->template = $template;
        $this->user = $user;
        $this->advRepository = $advRepository;
        $this->orderdetailRepository = $orderdetailRepository;
        $this->optionConfigurationRepository = $optionConfigurationRepository;
        $this->currency = $currency;
    }

    public function handle(OrderCreated $event)
    {
        $order = $event->getOrder();
        $user = $this->user->find($order->user_id);

        $adminRole = $this->roleRepository->findBySlug('admin');
        $admins = $adminRole->getUsers();
        $users = $admins->add($user);

        $items = '';
        foreach ($event->getOrderDetail()->get() as $detail) {
            $items .= "{$detail->getDetailName()}: {$this->currency->format($detail->price, $detail->currency)}<br><br>";
        }

        $mail_params = [
            'display_name' => $user->name(),
            'url' => route('orders::purchase_detail', ['id' => $order->id]),
            'order_id' => $order->id,
            'items' => $items,
        ];

        if ($template = $this->template->findBySlug('order_created')) {
            Notification::send($users, new MailTemplate($template->getTemplateForArray($mail_params)));
        }
    }
}
