<?php namespace Visiosoft\NotificationsModule\Template;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class TemplateSeeder extends Seeder
{

    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->template->create([
            'en' => [
                'message' => '<p><strong>&nbsp;Your post <a href="{url}" target="_blank">{name}</a> has been created successfully.</strong></p>',
                'name' => 'Created Ad',
                'greeting' => 'Hi',
                'subject' => 'Created Ad'
            ],
            'slug' => str_slug('Created Ad', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<p><strong>Your ad for&nbsp;<a href="{url}" target="_blank">{name}</a>&nbsp;has been approved.</strong></p>',
                'name' => 'Approved Ad',
                'greeting' => 'Hi',
                'subject' => 'Approved Ad'
            ],
            'slug' => str_slug('Approved Ad', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Your <a href="{url}" target="_blank">{name}</a>&nbsp;ad was rejected because it does not comply with the posting rules.</strong></p>',
                'name' => 'Declined Ad',
                'greeting' => 'Hi',
                'subject' => 'Declined Ad'
            ],
            'slug' => str_slug('Declined Ad', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>You must confirm your <a href="{url}" target="_blank">{name}</a>&nbsp;posting to be published.</strong></p>',
                'name' => 'Pending User Ad',
                'greeting' => 'Hi',
                'subject' => 'Pending User Ad'
            ],
            'slug' => str_slug('Pending User Ad', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Your <a href="{url}" target="_blank">{name}</a> post is checked by our editors.</strong></p>',
                'name' => 'Pending Ad',
                'greeting' => 'Hi',
                'subject' => 'Pending Ad'
            ],
            'slug' => str_slug('Pending Ad', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>Your membership is activated.<br>Email:{email}<br>Username:{username}</strong></p>',
                'name' => 'Registered User',
                'greeting' => 'Hi {first_name}',
                'subject' => 'Your Membership Has Been Successfully Created!'
            ],
            'slug' => str_slug('Registered User', '_')
        ]);
        $this->template->create([
            'en' => [
                'message' => '<p><strong>You have an upcoming reservation!<br>Location:{location}<br>Service:{service}<br>Staff:{staff}<br>Date:{date}</strong></p>',
                'name' => 'Reminding Tomorrow Booking',
                'greeting' => 'Hi {name}',
                'subject' => 'You have an upcoming reservation!'
            ],
            'slug' => str_slug('Reminding Tomorrow Booking', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<h4 class="text-center">Your Openclassify.com account has been successfully created.</h4><hr><p class="text-center"><strong>Your Login Information</strong></p><h5 class="text-center">{email}</h5><h5 class="text-center">{password}</h5><p class="text-center"><strong>You can login at&nbsp;<a href="{login_url}">{login_url}</a>.</strong></p><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                'name' => 'Openclassify User Created',
                'greeting' => 'Hi {display_name}',
                'subject' => 'Openclassify.com Giriş Bilgileriniz !'
            ],
            'slug' => str_slug('Openclassify User Created', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<h3 class="text-center">Your openclassify.com {subscription_name} package has been activated.</h3><h5 class="text-center">For a more elegant store, visit our Modules and Themes pages.</h5><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                'name' => 'Created Subscription',
                'greeting' => 'Hi {display_name}',
                'subject' => 'Your Openclassify.com Subscription Has Started!'
            ],
            'slug' => str_slug('Created Subscription', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<h3 class="text-center">Your openclassify.com {subscription_name} package has been activated.</h3><h5 class="text-center">For a more elegant store, visit our Modules and Themes pages.</h5><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                'name' => 'Created Subscription On Manuel',
                'greeting' => 'Hi {display_name}',
                'subject' => 'Your Openclassify.com Subscription Has Started on Hand!'
            ],
            'slug' => str_slug('Created Subscription On Manuel', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<h4 class="text-center">Your site {site_url} has been set up.</h4><hr><p class="text-center"><strong>Your Login Information</strong></p><h5 class="text-center">{email}</h5><h5 class="text-center">{password}</h5><p class="text-center"><strong>You can log in at&nbsp;<a href="{login_url}">{login_url}</a>.</strong></p><p class="text-center">Thank You.</p><h6 class="text-center">Openclassify Team</h6>',
                'name' => 'Created Site',
                'greeting' => 'Hi {display_name}',
                'subject' => 'Your site {site_url} has been set up! | Openclassify.com'
            ],
            'slug' => str_slug('Created Site', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<h4 class="text-center">Your site {site_url} has been set up.</h4><hr>',
                'name' => 'Guide For Site',
                'greeting' => '',
                'subject' => 'Your site {site_url} has been set up! | Openclassify.com'
            ],
            'slug' => str_slug('Guide For Site', '_')
        ]);

        $this->template->create([
            'en' => [
                'message' => '<h3 class="text-center">The plug-in "{addon_name}" that you purchased for {site_url} has been installed!</h3><p></p><h6 class="text-center">Openclassify Team</h6>',
                'name' => 'Installed Addon',
                'greeting' => 'Hi {display_name}',
                'subject' => 'The plug-in you purchased for {site_url} has been installed! | Openclassify.com'
            ],
            'slug' => str_slug('Installed Addon', '_')
        ]);
    }
}
