<?php namespace Visiosoft\NetgsmModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Illuminate\Routing\Router;
use Visiosoft\BookingModule\Booking\Events\ActivationBooking;
use Visiosoft\BookingModule\Booking\Events\CreateBooking;
use Visiosoft\BookingModule\Booking\Events\SendUserPassword;
use Visiosoft\NetgsmModule\Listener\ActivationBookingNetGSM;
use Visiosoft\NetgsmModule\Listener\CreateBookingNetGSM;
use Visiosoft\NetgsmModule\Listener\NetgsmListener;
use Visiosoft\NetgsmModule\Listener\NewAdNetGSM;
use Visiosoft\NetgsmModule\Listener\PaymentNetGSM;
use Visiosoft\NetgsmModule\Listener\SendUserPasswordNetGSM;
use Visiosoft\NetgsmModule\Listener\StatusAdNetGSM;
use Visiosoft\NetgsmModule\Listener\UnpublishAdNetGSM;
use Visiosoft\NetgsmModule\Listener\UpdateAdNetGSM;
use Visiosoft\NotificationsModule\Smsnotify\Event\NewAdSms;
use Visiosoft\NotificationsModule\Smsnotify\Event\PaymentSms;
use Visiosoft\NotificationsModule\Smsnotify\Event\StatusAdSms;
use Visiosoft\NotificationsModule\Smsnotify\Event\UnpublishAdSms;
use Visiosoft\NotificationsModule\Smsnotify\Event\UpdateAdSms;

class NetgsmModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\NetgsmModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\NetgsmModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        NewAdSms::class =>
            [
                NewAdNetGSM::class,
            ],
        PaymentSms::class =>
            [
                PaymentNetGSM::class,
            ],
        StatusAdSms::class =>
            [
                StatusAdNetGSM::class,
            ],
        UnpublishAdSms::class =>
            [
                UnpublishAdNetGSM::class,
            ],
        UpdateAdSms::class =>
            [
                UpdateAdNetGSM::class,
            ],

        //Booking Module
        CreateBooking::class =>
            [
                CreateBookingNetGSM::class,
            ],
        ActivationBooking::class =>
            [
                ActivationBookingNetGSM::class,
            ],
        SendUserPassword::class =>
            [
                SendUserPasswordNetGSM::class,
            ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\NetgsmModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
