<?php namespace Visiosoft\NetgsmModule\Listener;


use Visiosoft\BookingModule\Booking\Events\SendUserPassword;

class SendUserPasswordNetGSM
{
    public function handle(SendUserPassword $event)
    {
        if (setting_value('visiosoft.module.booking::password_sms_notify')) {
            $netgsmcontroller = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);

            $msg = html_entity_decode(
                setting_value('visiosoft.module.booking::password_sms_message')
                . " "
                . $event->password()
                , ENT_COMPAT, "UTF-8");
            $msg = rawurlencode($msg);
            $tel = $event->user()->phone_number;
            $netgsmcontroller->sendSMS($msg, $tel);
        }
    }
}
