<?php namespace Visiosoft\NetgsmModule\Listener;


use Visiosoft\BookingModule\Booking\Events\CreateBooking;

class CreateBookingNetGSM
{
    public function handle(CreateBooking $event)
    {
        $selected_home_msg = '';
        if (setting_value('visiosoft.module.booking::home_message_send_location') == $event->location()->id) {
            $selected_home_msg = setting_value('visiosoft.module.booking::home_message');
        }
        if (setting_value('visiosoft.module.booking::sms_notify')) {
            $netgsmcontroller = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);

            $msg = html_entity_decode(trans('visiosoft.module.booking::messages.sms_message')
                . date("d/m/Y H:i", strtotime($event->detail()->booking_datetime_start))
                . '-' . date("H:i", strtotime($event->detail()->booking_datetime_end)) . " "
                . $event->service()->name . " "
                . $event->location()->name . ' ' . $selected_home_msg, ENT_COMPAT, "UTF-8");
            $msg = rawurlencode($msg);
            $tel = $event->detail()->phone;
            $netgsmcontroller->sendSMS($msg, $tel);
        }
    }
}
