<?php namespace Visiosoft\NetgsmModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Visiosoft\ProfileModule\Profile\ProfileModel;

class NetgsmController extends PublicController
{
    private $settings;
    private $profileModel;

    public function __construct(SettingRepositoryInterface $settings, ProfileModel $profileModel)
    {
        parent::__construct();

        $this->settings = $settings;
        $this->profileModel = $profileModel;
    }

    public function netGSMListenerSend($msg, $user)
    {
        if ($this->settings->value('visiosoft.module.notifications::sms_extension') == "netgsm") {
            $user_id = $user->id;
            $profile = $this->profileModel->getProfile($user_id)->first();

            $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
            $msg = rawurlencode($msg);
            $tel = $profile->gsm_phone;
            $this->sendSMS($msg, $tel);
        }
    }

    public function sendSMS($msg, $telno)
    {
        $header = $this->settings->value('visiosoft.module.netgsm::netgsm_header');
        $netgsmuser = $this->settings->value('visiosoft.module.netgsm::netgsm_user');
        $netgsmpassword = $this->settings->value('visiosoft.module.netgsm::netgsm_pass');

        $startdate = date('d.m.Y H:i');
        $startdate = str_replace('.', '', $startdate);
        $startdate = str_replace(':', '', $startdate);
        $startdate = str_replace(' ', '', $startdate);

        $stopdate = date('d.m.Y H:i', strtotime('+1 day'));
        $stopdate = str_replace('.', '', $stopdate);
        $stopdate = str_replace(':', '', $stopdate);
        $stopdate = str_replace(' ', '', $stopdate);

        $header = html_entity_decode($header, ENT_COMPAT, "UTF-8");
        $header = rawurlencode($header);

        $url = "http://api.netgsm.com.tr/bulkhttppost.asp?usercode=" . $netgsmuser . "&password=" . $netgsmpassword . "&gsmno=$telno&message=$msg&msgheader=$header&startdate=$startdate&stopdate=$stopdate";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }

    public function handleMessage($number, $message)
    {
        $msg = html_entity_decode($message, ENT_COMPAT, "UTF-8");
        $msg = rawurlencode($msg);

        $this->sendSMS($msg, $number);
    }
}
