<?php namespace Visiosoft\NetgsmModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Message\MessageBag;

class NetgsmController extends PublicController
{
    private $settings;
    public $messages;

    public function __construct(SettingRepositoryInterface $settings, MessageBag $messages)
    {
        parent::__construct();

        $this->settings = $settings;
        $this->messages = $messages;
    }

    public function netGSMListenerSend($msg, $user)
    {
        if ($this->settings->value('visiosoft.module.notifications::sms_extension') == "netgsm") {
            $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
            $msg = rawurlencode($msg);
            $tel = $user->gsm_phone;
            $this->sendSMS($msg, $tel);
        }
    }

    public function sendSMS($msg, $telno)
    {
        $header = $this->settings->value('visiosoft.module.netgsm::netgsm_header');
        $netgsmuser = $this->settings->value('visiosoft.module.netgsm::netgsm_user');
        $netgsmpassword = $this->settings->value('visiosoft.module.netgsm::netgsm_pass');

        $startdate = date('d.m.Y H:i');
        $startdate = str_replace('.', '', $startdate);
        $startdate = str_replace(':', '', $startdate);
        $startdate = str_replace(' ', '', $startdate);

        $stopdate = date('d.m.Y H:i', strtotime('+1 day'));
        $stopdate = str_replace('.', '', $stopdate);
        $stopdate = str_replace(':', '', $stopdate);
        $stopdate = str_replace(' ', '', $stopdate);

        $header = html_entity_decode($header, ENT_COMPAT, "UTF-8");
        $header = rawurlencode($header);

        $url = "http://api.netgsm.com.tr/bulkhttppost.asp?usercode=" . $netgsmuser . "&password=" . $netgsmpassword . "&gsmno=$telno&message=$msg&msgheader=$header&startdate=$startdate&stopdate=$stopdate";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    $output = curl_exec($ch);
	    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	    curl_close($ch);

	    if ($http_code === 20) {
		    $this->messages->error(trans('visiosoft.module.netgsm::message.long_message') . ' ' . $http_code);
	    } elseif ($http_code === 30) {
		    $this->messages->error(trans('visiosoft.module.netgsm::message.invalid_user') . ' ' . $http_code);
	    } elseif ($http_code === 40) {
		    $this->messages->error(trans('visiosoft.module.netgsm::message.header_not_defined') . ' ' . $http_code);
	    } elseif ($http_code === 70) {
		    $this->messages->error(trans('visiosoft.module.netgsm::message.bad_parameter') . ' ' . $http_code);
	    } elseif ($http_code === 85) {
		    $this->messages->error(trans('visiosoft.module.netgsm::message.limit_overrun') . ' ' . $http_code);
	    } elseif ($http_code === 100 || $http_code === 101 || $http_code === 400) {
		    $this->messages->error(trans('visiosoft.module.netgsm::message.system_error') . ' ' . $http_code);
	    } elseif ($http_code === 200) {
		    $this->messages->success(trans('visiosoft.theme.base::message.send_forgot_sms'));
	    }

	    return $output;
    }

    public function handleMessage($number, $message)
    {
        $msg = html_entity_decode($message, ENT_COMPAT, "UTF-8");
        $msg = rawurlencode($msg);

        $this->sendSMS($msg, $number);
    }
}
