<?php namespace Visiosoft\NetgsmModule\Listener;


use Visiosoft\BookingModule\Booking\Events\ActivationBooking;

class ActivationBookingNetGSM
{
    public function handle(ActivationBooking $event)
    {
        if (setting_value('visiosoft.module.booking::activation_sms_notify')) {
            $netgsmcontroller = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);

            $msg = html_entity_decode(
                $event->detail()->activation_code
                . " "
                . setting_value('visiosoft.module.booking::activation_sms_message')
                . " "
                . setting_value('visiosoft.module.booking::activation_sms_link', 'http://bit.ly/31K4xua')
                , ENT_COMPAT, "UTF-8");
            $msg = rawurlencode($msg);
            $tel = $event->detail()->phone;
            $netgsmcontroller->sendSMS($msg, $tel);
        }
    }
}
